/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public abstract class TemplatePoolGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, TemplatePoolBuilder> builders = new HashMap<ResourceLocation, TemplatePoolBuilder>();

    public TemplatePoolGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public void save() {
        for (TemplatePoolBuilder pool : this.builders.values()) {
            List<ResourceLocation> missingStructures = pool.entries.stream().map(entry -> entry.location).collect(Collectors.toSet()).stream().filter(structure -> !this.cache.doesResourceExist(ResourceType.DATA, structure.m_135827_(), "structures", structure.m_135815_(), ".nbt")).toList();
            if (!missingStructures.isEmpty()) {
                throw new RuntimeException("Template pool '" + pool.identifier + "' has missing structure nbt files: " + missingStructures);
            }
            JsonObject json = new JsonObject();
            json.addProperty("fallback", pool.fallbackPool.toString());
            JsonArray entries = new JsonArray(pool.entries.size());
            for (TemplatePoolEntryBuilder entry2 : pool.entries) {
                JsonObject entryJson = new JsonObject();
                entryJson.addProperty("weight", (Number)entry2.weight);
                JsonObject propertyJson = new JsonObject();
                propertyJson.addProperty("element_type", entry2.type.toString());
                propertyJson.addProperty("location", entry2.location.toString());
                propertyJson.addProperty("projection", entry2.projection.m_7912_());
                if (entry2.groundLevel != null) {
                    propertyJson.addProperty("ground_level", (Number)entry2.groundLevel);
                }
                if (entry2.processors.isEmpty()) {
                    propertyJson.addProperty("processors", "minecraft:empty");
                } else {
                    JsonArray processors = new JsonArray(entry2.processors.size());
                    entry2.processors.stream().map(processor -> (JsonElement)StructureProcessorType.f_74465_.encodeStart((DynamicOps)JsonOps.INSTANCE, processor).getOrThrow(false, s -> {})).forEach(arg_0 -> ((JsonArray)processors).add(arg_0));
                    propertyJson.add("processors", (JsonElement)processors);
                }
                entryJson.add("element", (JsonElement)propertyJson);
                entries.add((JsonElement)entryJson);
            }
            json.add("elements", (JsonElement)entries);
            this.cache.saveJsonResource(ResourceType.DATA, json, pool.identifier.m_135827_(), "worldgen/template_pool", pool.identifier.m_135815_());
        }
    }

    public TemplatePoolBuilder pool(String namespace, String identifier) {
        return this.builders.computeIfAbsent(new ResourceLocation(namespace, identifier), i -> new TemplatePoolBuilder(this.modid, (ResourceLocation)i));
    }

    public TemplatePoolBuilder pool(String identifier) {
        return this.pool(this.modid, identifier);
    }

    public String getName() {
        return this.modName + " Template Pool Generator";
    }

    public static class TemplatePoolBuilder {
        private final String owningModid;
        private final ResourceLocation identifier;
        private ResourceLocation fallbackPool = new ResourceLocation("minecraft", "empty");
        private final List<TemplatePoolEntryBuilder> entries = new ArrayList<TemplatePoolEntryBuilder>();

        private TemplatePoolBuilder(String owningModid, ResourceLocation identifier) {
            this.owningModid = owningModid;
            this.identifier = identifier;
        }

        public TemplatePoolBuilder fallback(String namespace, String identifier) {
            this.fallbackPool = new ResourceLocation(namespace, identifier);
            return this;
        }

        public TemplatePoolBuilder entry(String template, Consumer<TemplatePoolEntryBuilder> entryBuilder) {
            TemplatePoolEntryBuilder entry = new TemplatePoolEntryBuilder(new ResourceLocation(this.owningModid, template));
            entryBuilder.accept(entry);
            this.entries.add(entry);
            return this;
        }

        public TemplatePoolBuilder commonEntries(BiConsumer<String, TemplatePoolEntryBuilder> entryBuilder, String ... templates) {
            Arrays.stream(templates).forEach(t -> this.entry((String)t, o -> entryBuilder.accept((String)t, (TemplatePoolEntryBuilder)o)));
            return this;
        }

        public TemplatePoolBuilder commonEntries(Consumer<TemplatePoolEntryBuilder> entryBuilder, String ... templates) {
            return this.commonEntries((String template, TemplatePoolEntryBuilder builder) -> entryBuilder.accept((TemplatePoolEntryBuilder)builder), templates);
        }
    }

    public static class TemplatePoolEntryBuilder {
        private final ResourceLocation location;
        private final List<StructureProcessor> processors = new ArrayList<StructureProcessor>();
        private StructureTemplatePool.Projection projection = StructureTemplatePool.Projection.RIGID;
        private Integer groundLevel;
        private ResourceLocation type = new ResourceLocation("formations", "single_pool_element");
        private int weight = 1;

        private TemplatePoolEntryBuilder(ResourceLocation location) {
            this.location = location;
        }

        public TemplatePoolEntryBuilder processors(StructureProcessor ... processors) {
            this.processors.addAll(Arrays.asList(processors));
            return this;
        }

        public TemplatePoolEntryBuilder rigidProjection() {
            this.projection = StructureTemplatePool.Projection.RIGID;
            return this;
        }

        public TemplatePoolEntryBuilder terrainMatchingProjection() {
            this.projection = StructureTemplatePool.Projection.TERRAIN_MATCHING;
            return this;
        }

        public TemplatePoolEntryBuilder groundLevel(int level) {
            this.groundLevel = level;
            return this;
        }

        public TemplatePoolEntryBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }
    }
}

