/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import com.google.common.base.Preconditions;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.config.ForestryConfig;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.ItemInventory;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.items.ItemWithGui;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.storage.BackpackMode;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.inventory.ItemInventoryBackpack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class ItemBackpack
extends ItemWithGui
implements IColoredItem {
    public static final int SLOTS_BACKPACK_DEFAULT = 15;
    public static final int SLOTS_BACKPACK_WOVEN = 45;
    public static final int SLOTS_BACKPACK_APIARIST = 125;
    private final IBackpackDefinition definition;
    private final EnumBackpackType type;

    public ItemBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        super(new Item.Properties());
        this.definition = definition;
        this.type = type;
    }

    public IBackpackDefinition getDefinition() {
        return this.definition;
    }

    @Override
    protected void writeContainerData(ServerPlayer player, ItemStack stack, FriendlyByteBuf buffer) {
        NetworkUtil.writeEnum(buffer, this.type == EnumBackpackType.WOVEN ? ContainerBackpack.Size.T2 : ContainerBackpack.Size.DEFAULT);
        buffer.m_130055_(stack);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!playerIn.m_6144_()) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        ItemStack heldItem = playerIn.m_21120_(handIn);
        ItemBackpack.switchMode(heldItem);
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (ItemBackpack.getInventoryHit(level, ctx.m_8083_(), ctx.m_43719_()) != null) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            ItemStack heldItem = player.m_21120_(context.m_43724_());
            return this.evaluateTileHit(heldItem, player, context.m_43725_(), context.m_8083_(), context.m_43719_()) ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static void tryStowing(Player player, ItemStack backpackStack, ItemStack stack) {
        if (ItemBackpack.getMode(backpackStack) == BackpackMode.LOCKED) {
            return;
        }
        ItemBackpack backpack = (ItemBackpack)backpackStack.m_41720_();
        ItemInventoryBackpack inventory = new ItemInventoryBackpack(player, backpack.getBackpackSize(), backpackStack);
        if (MinecraftForge.EVENT_BUS.post((Event)new BackpackStowEvent(player, backpack.getDefinition(), inventory, stack))) {
            return;
        }
        if (stack.m_41619_()) {
            return;
        }
        IItemHandler itemHandler = inventory.getItemHandler();
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(itemHandler);
        ItemStack remainder = manipulator.addStack(stack);
        stack.m_41764_(remainder == null ? 0 : remainder.m_41613_());
    }

    private static void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        int nextMode = mode.ordinal() + 1;
        if (!((Boolean)ForestryConfig.SERVER.enableBackpackResupply.get()).booleanValue() && nextMode == BackpackMode.RESUPPLY.ordinal()) {
            ++nextMode;
        }
        itemstack.m_41721_(nextMode %= BackpackMode.VALUES.length);
    }

    @Nullable
    private static IItemHandler getInventoryHit(Level world, BlockPos pos, Direction side) {
        BlockEntity targeted = TileUtil.getTile((BlockGetter)world, pos);
        return TileUtil.getInventoryFromTile(targeted, side);
    }

    private boolean evaluateTileHit(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        IItemHandler inventory = ItemBackpack.getInventoryHit(world, pos, side);
        if (inventory != null) {
            if (inventory.getSlots() <= 0) {
                return true;
            }
            if (!world.f_46443_) {
                ItemInventoryBackpack backpackInventory = new ItemInventoryBackpack(player, this.getBackpackSize(), stack);
                BackpackMode mode = ItemBackpack.getMode(stack);
                if (mode == BackpackMode.RECEIVE) {
                    this.receiveFromChest(backpackInventory, inventory);
                } else {
                    ItemBackpack.transferToChest(backpackInventory, inventory);
                }
            }
            return true;
        }
        return false;
    }

    private static void transferToChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(backpackInventory.getItemHandler());
        manipulator.transferStacks(target, StandardStackFilters.ALL);
    }

    private void receiveFromChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(target);
        manipulator.transferStacks(backpackInventory.getItemHandler(), this.definition.getFilter());
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        int occupied = ItemInventory.getOccupiedSlotCount(itemstack);
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        String infoKey = mode.getTranslationKey();
        if (infoKey != null) {
            list.add((Component)Component.m_237115_((String)infoKey).m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237110_((String)"for.gui.slots", (Object[])new Object[]{String.valueOf(occupied), String.valueOf(this.getBackpackSize())}).m_130940_(ChatFormatting.GRAY));
    }

    public Component m_7626_(ItemStack itemstack) {
        return this.definition.getName(itemstack);
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int layer) {
        if (layer == 0) {
            return this.definition.getPrimaryColour();
        }
        if (layer == 1) {
            return this.definition.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    private static int getSlotsForType(EnumBackpackType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumBackpackType.NATURALIST -> 125;
            case EnumBackpackType.WOVEN -> 45;
            case EnumBackpackType.NORMAL -> 15;
        };
    }

    public static BackpackMode getMode(ItemStack backpack) {
        if (!(backpack.m_41720_() instanceof ItemBackpack)) {
            return BackpackMode.NEUTRAL;
        }
        int meta = Mth.m_14045_((int)backpack.m_41773_(), (int)0, (int)3);
        return BackpackMode.VALUES[meta];
    }

    public static EnumBackpackType getType(ItemStack backpack) {
        Preconditions.checkArgument((boolean)(backpack.m_41720_() instanceof ItemBackpack), (Object)"Item must be a backpack");
        return ((ItemBackpack)backpack.m_41720_()).type;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        Item newItem;
        Item oldItem = oldStack.m_41720_();
        return oldItem != (newItem = newStack.m_41720_()) || ItemBackpack.getMode(oldStack) != ItemBackpack.getMode(newStack);
    }

    @Override
    @Nullable
    public AbstractContainerMenu getContainer(int windowId, Player player, ItemStack heldItem) {
        Item item = heldItem.m_41720_();
        if (!(item instanceof ItemBackpack)) {
            return null;
        }
        ItemBackpack backpack = (ItemBackpack)item;
        return switch (backpack.type) {
            case EnumBackpackType.NORMAL -> new ContainerBackpack(windowId, player, ContainerBackpack.Size.DEFAULT, heldItem);
            case EnumBackpackType.WOVEN -> new ContainerBackpack(windowId, player, ContainerBackpack.Size.T2, heldItem);
            default -> null;
        };
    }
}

