/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.blocks;

import forestry.core.blocks.BlockForestry;
import forestry.core.tiles.TileUtil;
import forestry.sorting.tiles.TileGeneticFilter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BlockGeneticFilter
extends BlockForestry
implements EntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final AABB BOX_CENTER = new AABB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AABB BOX_DOWN = new AABB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75);
    private static final AABB BOX_UP = new AABB(0.25, 0.6875, 0.25, 0.75, 1.0, 0.75);
    private static final AABB BOX_NORTH = new AABB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125);
    private static final AABB BOX_SOUTH = new AABB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0);
    private static final AABB BOX_WEST = new AABB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75);
    private static final AABB BOX_EAST = new AABB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AABB[] BOX_FACES = new AABB[]{BOX_DOWN, BOX_UP, BOX_NORTH, BOX_SOUTH, BOX_WEST, BOX_EAST};

    public BlockGeneticFilter() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.25f, 3.0f).m_60988_().m_60955_(), false);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState changedState, LevelAccessor world, BlockPos pos, BlockPos changedPos) {
        TileGeneticFilter geneticFilter = TileUtil.getTile((BlockGetter)world, pos, TileGeneticFilter.class);
        if (geneticFilter == null) {
            return this.m_49966_();
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.WEST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.DOWN)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult rayTraceResult) {
        TileGeneticFilter tile = TileUtil.getTile((BlockGetter)worldIn, pos, TileGeneticFilter.class);
        if (tile != null && TileUtil.isUsableByPlayer(playerIn, tile)) {
            if (!worldIn.f_46443_) {
                ServerPlayer sPlayer = (ServerPlayer)playerIn;
                NetworkHooks.openScreen((ServerPlayer)sPlayer, (MenuProvider)tile, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileGeneticFilter(pos, state);
    }
}

