/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.mail.MailAddress;
import forestry.mail.TradeStation;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.gui.ContainerTrader;
import forestry.mail.inventory.InventoryTradeStation;
import forestry.mail.network.packets.PacketTraderAddressResponse;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileTrader
extends TileBase
implements IOwnedTile {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private IMailAddress address = new MailAddress();

    public TileTrader(BlockPos pos, BlockState state) {
        super(MailTiles.TRADER.tileType(), pos, state);
        this.setInternalInventory(new InventoryTradeStation());
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public void onDropContents(ServerLevel level) {
        if (this.isLinked()) {
            PostManager.postRegistry.deleteTradeStation((ServerLevel)this.f_58857_, this.address);
        }
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        CompoundTag nbt = new CompoundTag();
        this.address.write(nbt);
        compoundNBT.m_128365_("address", (Tag)nbt);
        this.ownerHandler.write(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        if (compoundNBT.m_128441_("address")) {
            this.address = new MailAddress(compoundNBT.m_128469_("address"));
        }
        this.ownerHandler.read(compoundNBT);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        this.ownerHandler.writeData(data);
        String addressName = this.address.getName();
        data.m_130070_(addressName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.ownerHandler.readData(data);
        String addressName = data.m_130277_();
        if (!addressName.isEmpty()) {
            this.address = PostManager.postRegistry.getMailAddress(addressName);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.isLinked() || !this.updateOnInterval(10)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.hasPostageMin(3), ForestryError.NO_STAMPS);
        errorLogic.setCondition(!this.hasPaperMin(2), ForestryError.NO_PAPER);
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack tradeGood = inventory.m_8020_(0);
        errorLogic.setCondition(tradeGood.m_41619_(), ForestryError.NO_TRADE);
        boolean hasRequest = this.hasItemCount(1, 4, ItemStack.f_41583_, 1);
        errorLogic.setCondition(!hasRequest, ForestryError.NO_TRADE);
        if (!tradeGood.m_41619_()) {
            boolean hasSupplies = this.hasItemCount(30, 10, tradeGood, tradeGood.m_41613_());
            errorLogic.setCondition(!hasSupplies, ForestryError.NO_SUPPLIES);
        }
        if (inventory instanceof TradeStation && this.updateOnInterval(200)) {
            boolean canReceivePayment = ((TradeStation)inventory).canReceivePayment();
            errorLogic.setCondition(!canReceivePayment, ForestryError.NO_SPACE_INVENTORY);
        }
    }

    public boolean isLinked() {
        if (!this.address.isValid()) {
            return false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        return !errorLogic.contains(ForestryError.NOT_ALPHANUMERIC) && !errorLogic.contains(ForestryError.NOT_UNIQUE);
    }

    private boolean hasItemCount(int startSlot, int countSlots, ItemStack item, int itemCount) {
        int count = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.m_8020_(i);
            if (itemInSlot.m_41619_()) continue;
            if (item.m_41619_() || ItemStackUtil.isIdenticalItem(itemInSlot, item)) {
                count += itemInSlot.m_41613_();
            }
            if (count < itemCount) continue;
            return true;
        }
        return false;
    }

    private float percentOccupied(int startSlot, int countSlots, ItemStack item) {
        int count = 0;
        int total = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = startSlot; i < startSlot + countSlots; ++i) {
            ItemStack itemInSlot = tradeInventory.m_8020_(i);
            if (itemInSlot.m_41619_()) {
                total += tradeInventory.m_6893_();
                continue;
            }
            total += itemInSlot.m_41741_();
            if (!item.m_41619_() && !ItemStackUtil.isIdenticalItem(itemInSlot, item)) continue;
            count += itemInSlot.m_41613_();
        }
        return (float)count / (float)total;
    }

    public boolean hasPaperMin(int count) {
        return this.hasItemCount(5, 6, new ItemStack((ItemLike)Items.f_42516_), count);
    }

    public boolean hasPostageMin(int postage) {
        int posted = 0;
        IInventoryAdapter tradeInventory = this.getInternalInventory();
        for (int i = 11; i < 15; ++i) {
            ItemStack stamp = tradeInventory.m_8020_(i);
            if (stamp.m_41619_() || !(stamp.m_41720_() instanceof IStamps) || (posted += ((IStamps)stamp.m_41720_()).getPostage(stamp).getValue() * stamp.m_41613_()) < postage) continue;
            return true;
        }
        return false;
    }

    public IMailAddress getAddress() {
        return this.address;
    }

    public void handleSetAddressRequest(String addressName) {
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
        IMailAddress newAddress = this.getAddress();
        String newAddressName = newAddress.getName();
        if (newAddressName.equals(addressName)) {
            PacketTraderAddressResponse packetResponse = new PacketTraderAddressResponse(this.f_58858_, addressName);
            NetworkUtil.sendNetworkPacket(packetResponse, this.f_58858_, this.f_58857_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleSetAddressResponse(String addressName) {
        IMailAddress address = PostManager.postRegistry.getMailAddress(addressName);
        this.setAddress(address);
    }

    private void setAddress(IMailAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null");
        if (this.address.isValid() && this.address.equals(address)) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            ServerLevel world = (ServerLevel)this.f_58857_;
            IErrorLogic errorLogic = this.getErrorLogic();
            boolean hasValidTradeAddress = PostManager.postRegistry.isValidTradeAddress((Level)world, address);
            errorLogic.setCondition(!hasValidTradeAddress, ForestryError.NOT_ALPHANUMERIC);
            boolean hasUniqueTradeAddress = PostManager.postRegistry.isAvailableTradeAddress(world, address);
            errorLogic.setCondition(!hasUniqueTradeAddress, ForestryError.NOT_UNIQUE);
            if (hasValidTradeAddress & hasUniqueTradeAddress) {
                this.address = address;
                PostManager.postRegistry.getOrCreateTradeStation(world, this.getOwnerHandler().getOwner(), address);
            }
        } else {
            this.address = address;
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.f_58857_.f_46443_ || !this.address.isValid()) {
            return super.getInternalInventory();
        }
        return (TradeStation)PostManager.postRegistry.getOrCreateTradeStation((ServerLevel)this.f_58857_, this.getOwnerHandler().getOwner(), this.address);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        if (this.isLinked()) {
            return new ContainerTrader(windowId, inv, this);
        }
        return new ContainerTradeName(windowId, inv, this);
    }
}

