/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import forestry.api.mail.IStamps;
import forestry.api.mail.PostManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerStampCollector;
import forestry.mail.inventory.InventoryStampCollector;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileStampCollector
extends TileBase
implements Container {
    public TileStampCollector(BlockPos pos, BlockState state) {
        super(MailTiles.STAMP_COLLECTOR.tileType(), pos, state);
        this.setInternalInventory(new InventoryStampCollector(this));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.updateOnInterval(20)) {
            return;
        }
        ItemStack stamp = null;
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.m_8020_(0).m_41619_()) {
            stamp = PostManager.postRegistry.getPostOffice((ServerLevel)level).getAnyStamp(1);
        } else {
            ItemStack filter = inventory.m_8020_(0);
            if (filter.m_41720_() instanceof IStamps) {
                stamp = PostManager.postRegistry.getPostOffice((ServerLevel)level).getAnyStamp(((IStamps)filter.m_41720_()).getPostage(filter), 1);
            }
        }
        if (stamp == null) {
            return;
        }
        InventoryUtil.stowInInventory(stamp, (Container)inventory, true, 1, 27);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerStampCollector(windowId, inv, this);
    }
}

