/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.EnumDeliveryState;
import forestry.mail.PostRegistry;
import forestry.mail.features.MailTiles;
import forestry.mail.gui.ContainerMailbox;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileMailbox
extends TileBase {
    public TileMailbox(BlockPos pos, BlockState state) {
        super(MailTiles.MAILBOX.tileType(), pos, state);
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack heldItem = player.m_21120_(player.m_7655_());
        if (PostManager.postRegistry.isLetter(heldItem)) {
            IPostalState result = this.tryDispatchLetter(heldItem);
            if (!result.isOk()) {
                player.m_213846_(result.getDescription());
            } else {
                heldItem.m_41774_(1);
            }
        } else {
            super.openGui(player, hand, pos);
        }
    }

    public Container getOrCreateMailInventory(Level world, GameProfile playerProfile) {
        if (world.f_46443_) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox((ServerLevel)world, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterStack) {
        IPostalState result;
        ILetter letter = PostManager.postRegistry.getLetter(letterStack);
        if (letter != null) {
            ServerLevel world = (ServerLevel)this.f_58857_;
            result = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, letterStack, true);
        } else {
            result = EnumDeliveryState.NOT_MAILABLE;
        }
        return result;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerMailbox(windowId, inv, this);
    }
}

