/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.utils.NetworkUtil;
import forestry.mail.TradeStationInfo;
import forestry.mail.gui.ILetterInfoReceiver;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record PacketLetterInfoResponseTrader(@Nullable ITradeStationInfo info) implements IForestryPacketClient
{
    @Override
    public ResourceLocation id() {
        return PacketIdClient.LETTER_INFO_RESPONSE_TRADER;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        if (this.info == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.info.address().getName());
            GameProfile profile = this.info.owner();
            buffer.m_130077_(profile.getId());
            buffer.m_130070_(profile.getName());
            buffer.m_130055_(this.info.tradegood());
            NetworkUtil.writeItemStacks(buffer, this.info.required());
            buffer.m_130068_((Enum)this.info.state());
        }
    }

    public static PacketLetterInfoResponseTrader decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            IMailAddress address = PostManager.postRegistry.getMailAddress(buffer.m_130277_());
            GameProfile owner = new GameProfile(buffer.m_130259_(), buffer.m_130277_());
            ItemStack tradegood = buffer.m_130267_();
            NonNullList<ItemStack> required = NetworkUtil.readItemStacks(buffer);
            EnumTradeStationState state = (EnumTradeStationState)buffer.m_130066_(EnumTradeStationState.class);
            return new PacketLetterInfoResponseTrader(new TradeStationInfo(address, owner, tradegood, (List<ItemStack>)required, state));
        }
        return new PacketLetterInfoResponseTrader(null);
    }

    public static void handle(PacketLetterInfoResponseTrader msg, Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ILetterInfoReceiver) {
            ILetterInfoReceiver receiver = (ILetterInfoReceiver)abstractContainerMenu;
            receiver.handleLetterInfoUpdate(EnumAddressee.TRADER, null, msg.info);
        }
    }
}

