/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.platform.Window;
import forestry.api.ForestryConstants;
import forestry.core.config.ForestryConfig;
import forestry.core.utils.SoundUtil;
import forestry.mail.POBoxInfo;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiMailboxInfo {
    public static final GuiMailboxInfo INSTANCE = new GuiMailboxInfo();
    private static final int WIDTH = 98;
    private static final int HEIGHT = 17;
    private final Font font;
    @Nullable
    private POBoxInfo poInfo;
    private static final ResourceLocation ALERT_TEXTURE = ForestryConstants.forestry("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public void render(GuiGraphics graphics) {
        if (this.poInfo == null || !((Boolean)ForestryConfig.CLIENT.mailAlertsEnabled.get()).booleanValue() || !this.poInfo.hasMail()) {
            return;
        }
        int x = 0;
        int y = 0;
        Minecraft minecraft = Minecraft.m_91087_();
        Window win = minecraft.m_91268_();
        if (((Boolean)ForestryConfig.CLIENT.mailAlertsOnRight.get()).booleanValue()) {
            x = win.m_85445_() - 98;
        }
        if (((Boolean)ForestryConfig.CLIENT.mailAlertsOnBottom.get()).booleanValue()) {
            y = win.m_85446_() - 17;
        }
        graphics.m_280218_(ALERT_TEXTURE, x, y, 0, 0, 98, 17);
        graphics.m_280488_(this.font, Integer.toString(this.poInfo.playerLetters()), x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters()), 22), y + 5, 0xFFFFFF);
        graphics.m_280488_(this.font, Integer.toString(this.poInfo.tradeLetters()), x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters()), 22), y + 5, 0xFFFFFF);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.font.m_92895_(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPOBoxInfo(Player player, POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters() != info.playerLetters() || this.poInfo.tradeLetters() != info.tradeLetters()) {
                playJingle = true;
            }
        }
        if (playJingle) {
            SoundUtil.playSoundEvent((Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvents.f_12275_));
        }
        this.poInfo = info;
    }
}

