/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SlotUtil;
import forestry.mail.POBox;
import forestry.mail.POBoxInfo;
import forestry.mail.features.MailMenuTypes;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import forestry.mail.tiles.TileMailbox;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.level.BlockGetter;

public class ContainerMailbox
extends ContainerTile<TileMailbox> {
    public static final short SLOT_LETTERS = 0;
    public static final short SLOT_LETTERS_COUNT = 84;
    @Nullable
    private final POBox mailInventory;

    public static ContainerMailbox fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        TileMailbox tile = TileUtil.getTile((BlockGetter)inv.f_35978_.m_9236_(), data.m_130135_(), TileMailbox.class);
        return new ContainerMailbox(windowId, inv, tile);
    }

    public ContainerMailbox(int windowId, Inventory playerInventory, TileMailbox tile) {
        super(windowId, MailMenuTypes.MAILBOX.menuType(), playerInventory, tile, 35, 145);
        Container inventory = tile.getOrCreateMailInventory(playerInventory.f_35978_.m_9236_(), playerInventory.f_35978_.m_36316_());
        this.mailInventory = inventory instanceof POBox ? (POBox)inventory : null;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 12; ++j) {
                this.m_38897_(new SlotOutput(inventory, j + i * 9, 8 + j * 18, 8 + i * 18));
            }
        }
    }

    @Override
    public void m_150399_(int slotId, int button, ClickType clickTypeIn, Player player) {
        super.m_150399_(slotId, button, clickTypeIn, player);
        if (SlotUtil.isSlotInRange(slotId, 0, 84) && !player.m_9236_().f_46443_ && this.mailInventory != null) {
            POBoxInfo info = this.mailInventory.getPOBoxInfo();
            NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(info), (ServerPlayer)player);
        }
    }
}

