/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.ITradeStationInfo;
import forestry.api.mail.PostManager;
import forestry.core.gui.IGuiSelectable;
import forestry.core.utils.NetworkUtil;
import forestry.mail.features.MailMenuTypes;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.network.packets.PacketLetterInfoResponseTrader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;

public class ContainerCatalogue
extends AbstractContainerMenu
implements IGuiSelectable,
ILetterInfoReceiver {
    private final Player player;
    private final List<ITradeStation> stations = new ArrayList<ITradeStation>();
    @Nullable
    private ITradeStationInfo currentTrade = null;
    private int stationIndex = 0;
    private int stationCount;
    private boolean needsSync = true;
    private int currentFilter = 1;
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final List<Set<IPostalState>> FILTERS = new ArrayList<Set<IPostalState>>();

    public static ContainerCatalogue fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        return new ContainerCatalogue(windowId, inv);
    }

    public ContainerCatalogue(int windowId, Inventory inv) {
        super(MailMenuTypes.CATALOGUE.menuType(), windowId);
        this.player = inv.f_35978_;
        if (!this.player.m_9236_().f_46443_) {
            this.rebuildStationsList();
        }
    }

    public int getPageCount() {
        return Math.max(this.stationCount, 1);
    }

    public int getPageNumber() {
        return this.stationIndex + 1;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter];
    }

    private void rebuildStationsList() {
        if (!this.player.m_9236_().f_46443_) {
            return;
        }
        this.stations.clear();
        IPostOffice postOffice = PostManager.postRegistry.getPostOffice((ServerLevel)this.player.m_9236_());
        Map<IMailAddress, ITradeStation> tradeStations = postOffice.getActiveTradeStations(this.player.m_9236_());
        for (ITradeStation station : tradeStations.values()) {
            ITradeStationInfo info = station.getTradeInfo();
            if (!FILTERS.get(this.currentFilter).contains(info.state())) continue;
            this.stations.add(station);
        }
        this.stationIndex = 0;
        this.updateTradeInfo();
    }

    public void nextPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex = (this.stationIndex + 1) % this.stations.size();
            this.updateTradeInfo();
        }
    }

    public void previousPage() {
        if (!this.stations.isEmpty()) {
            this.stationIndex = (this.stationIndex - 1 + this.stations.size()) % this.stations.size();
            this.updateTradeInfo();
        }
    }

    public void cycleFilter() {
        this.currentFilter = (this.currentFilter + 1) % FILTERS.size();
        this.rebuildStationsList();
    }

    private void updateTradeInfo() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (!this.stations.isEmpty()) {
            ITradeStation station = this.stations.get(this.stationIndex);
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSync = true;
    }

    @Override
    public void handleLetterInfoUpdate(EnumAddressee type, @Nullable IMailAddress address, @Nullable ITradeStationInfo tradeInfo) {
        this.setTradeInfo(tradeInfo);
    }

    @Nullable
    public ITradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(@Nullable ITradeStationInfo info) {
        this.currentTrade = info;
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.needsSync) {
            for (ContainerListener crafter : this.f_38848_) {
                crafter.m_142153_((AbstractContainerMenu)this, 0, this.stationIndex);
                crafter.m_142153_((AbstractContainerMenu)this, 1, this.stations.size());
                crafter.m_142153_((AbstractContainerMenu)this, 2, this.currentFilter);
            }
            NetworkUtil.sendToPlayer(new PacketLetterInfoResponseTrader(this.currentTrade), (ServerPlayer)this.player);
            this.needsSync = false;
        }
    }

    public void m_7511_(int i, int j) {
        switch (i) {
            case 0: {
                this.stationIndex = j;
                break;
            }
            case 1: {
                this.stationCount = j;
                break;
            }
            case 2: {
                this.currentFilter = j;
            }
        }
    }

    public boolean m_6875_(Player p_75145_1_) {
        return true;
    }

    @Override
    public void handleSelectionRequest(ServerPlayer player, int primary, int secondary) {
        switch (primary) {
            case 0: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
                break;
            }
            case 2: {
                this.cycleFilter();
            }
        }
        this.needsSync = true;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    static {
        EnumSet<EnumTradeStationState> all = EnumSet.allOf(EnumTradeStationState.class);
        EnumSet<EnumTradeStationState> online = EnumSet.of(EnumTradeStationState.OK);
        EnumSet<EnumTradeStationState> offline = EnumSet.copyOf(all);
        offline.removeAll(online);
        FILTERS.add(Collections.unmodifiableSet(all));
        FILTERS.add(Collections.unmodifiableSet(online));
        FILTERS.add(Collections.unmodifiableSet(offline));
    }
}

