/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.client.ForestrySprites;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.PostManager;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.mail.gui.ContainerLetter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class AddresseeSlot
extends Widget {
    private final ContainerLetter containerLetter;

    public AddresseeSlot(WidgetManager widgetManager, int xPos, int yPos, ContainerLetter containerLetter) {
        super(widgetManager, xPos, yPos);
        this.containerLetter = containerLetter;
        this.width = 26;
        this.height = 15;
    }

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        IPostalCarrier carrier = PostManager.postRegistry.getCarrier(this.containerLetter.getCarrierType());
        if (carrier != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
            graphics.m_280159_(startX + this.xPos, startY + this.yPos, 0, 32, 32, carrier.getSprite());
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ToolTip tooltip = new ToolTip();
        tooltip.translated("for.gui.addressee." + this.containerLetter.getCarrierType(), new Object[0]);
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (!this.containerLetter.getLetter().isProcessed()) {
            this.containerLetter.advanceCarrierType();
            SoundUtil.playButtonClick();
        }
    }
}

