/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.EnumTradeStationState;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.MailAddress;
import forestry.mail.ResponseNotMailable;
import forestry.mail.TradeStationInfo;
import forestry.mail.features.MailItems;
import forestry.mail.inventory.InventoryTradeStation;
import forestry.mail.items.EnumStampDefinition;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.saveddata.SavedData;

public class TradeStation
extends SavedData
implements ITradeStation,
IInventoryAdapter {
    public static final String SAVE_NAME = "trade_po_";
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_TRADEGOOD_COUNT = 1;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_RECEIVE_BUFFER = 15;
    public static final short SLOT_RECEIVE_BUFFER_COUNT = 15;
    public static final short SLOT_SEND_BUFFER = 30;
    public static final short SLOT_SEND_BUFFER_COUNT = 10;
    public static final int SLOT_SIZE = 40;
    @Nullable
    private GameProfile owner;
    @Nullable
    private IMailAddress address;
    private boolean isVirtual = false;
    private boolean isInvalid = false;
    private final InventoryAdapter inventory = new InventoryTradeStation();

    public TradeStation(@Nullable GameProfile owner, IMailAddress address) {
        if (address.getType() != EnumAddressee.TRADER) {
            throw new IllegalArgumentException("TradeStation address must be a trader");
        }
        this.owner = owner;
        this.address = address;
    }

    public TradeStation(CompoundTag tag) {
        if (tag.m_128441_("owner")) {
            this.owner = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("owner"));
        }
        if (tag.m_128441_("address")) {
            this.address = new MailAddress(tag.m_128469_("address"));
        }
        this.isVirtual = tag.m_128471_("VRT");
        this.isInvalid = tag.m_128471_("IVL");
        this.inventory.read(tag);
    }

    @Override
    public IMailAddress getAddress() {
        return this.address;
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        CompoundTag nbt;
        if (this.owner != null) {
            nbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)nbt, (GameProfile)this.owner);
            compoundNBT.m_128365_("owner", (Tag)nbt);
        }
        if (this.address != null) {
            nbt = new CompoundTag();
            this.address.write(nbt);
            compoundNBT.m_128365_("address", (Tag)nbt);
        }
        compoundNBT.m_128379_("VRT", this.isVirtual);
        compoundNBT.m_128379_("IVL", this.isInvalid);
        this.inventory.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        return this.m_7176_(nbt);
    }

    @Override
    public void read(CompoundTag nbt) {
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.m_77762_();
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public TradeStationInfo getTradeInfo() {
        List<ItemStack> condensedRequired = ItemStackUtil.condenseStacks(InventoryUtil.getStacks((Container)this.inventory, 1, 4));
        EnumTradeStationState state = EnumTradeStationState.OK;
        if (!this.isVirtual()) {
            if (!this.hasPaper(2)) {
                state = EnumTradeStationState.INSUFFICIENT_PAPER;
            }
            if (!this.canPayPostage(3)) {
                state = EnumTradeStationState.INSUFFICIENT_STAMPS;
            }
            if (this.countFillableOrders(1, this.inventory.m_8020_(0)) <= 0) {
                state = EnumTradeStationState.INSUFFICIENT_TRADE_GOOD;
            }
        }
        return new TradeStationInfo(this.address, this.owner, this.inventory.m_8020_(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(ServerLevel world, IMailAddress recipient, ItemStack letterstack, boolean doLodge) {
        boolean sendOwnerNotice = doLodge && this.owner != null;
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        if (!this.isVirtual() && !this.hasPaper(sendOwnerNotice ? 2 : 1)) {
            return EnumTradeStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFillCount = ItemStackUtil.containsSets(InventoryUtil.getStacks((Container)this.inventory, 1, 4), letter.getAttachments());
        if (ordersToFillCount <= 0) {
            return EnumTradeStationState.INSUFFICIENT_OFFER;
        }
        if (!this.isVirtual()) {
            int storable;
            int fillable = this.countFillableOrders(ordersToFillCount, this.inventory.m_8020_(0));
            if (fillable <= 0) {
                return EnumTradeStationState.INSUFFICIENT_TRADE_GOOD;
            }
            if (fillable < ordersToFillCount) {
                ordersToFillCount = fillable;
            }
            if ((storable = this.countStorablePayment(ordersToFillCount, InventoryUtil.getStacks((Container)this.inventory, 1, 4))) <= 0) {
                return EnumTradeStationState.INSUFFICIENT_BUFFER;
            }
            if (storable < ordersToFillCount) {
                ordersToFillCount = storable;
            }
        }
        Letter mail = new Letter(this.address, letter.getSender());
        mail.setText(Component.m_237115_((String)"for.gui.mail.order.attached").getString());
        for (int i = 0; i < ordersToFillCount; ++i) {
            mail.addAttachment(this.inventory.m_8020_(0).m_41777_());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFillCount, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.isVirtual() && !this.canPayPostage(requiredPostage + (sendOwnerNotice ? 1 : 0))) {
            return EnumTradeStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage, this.isVirtual());
        for (int i = 0; i < stampCount.length; ++i) {
            int count = stampCount[i];
            if (count <= 0) continue;
            EnumPostage postage = EnumPostage.values()[i];
            EnumStampDefinition stampDefinition = EnumStampDefinition.getFromPostage(postage);
            mail.addStamps(MailItems.STAMPS.stack(stampDefinition, count));
        }
        CompoundTag compoundNBT = new CompoundTag();
        mail.write(compoundNBT);
        ItemStack mailstack = LetterProperties.createStampedLetterStack(mail);
        mailstack.m_41751_(compoundNBT);
        IPostalState responseState = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return new ResponseNotMailable(responseState);
        }
        for (int i = 0; i < ordersToFillCount; ++i) {
            for (ItemStack stack : InventoryUtil.getStacks((Container)this.inventory, 1, 4)) {
                if (stack == null) continue;
                InventoryUtil.tryAddStack((Container)this.inventory, stack.m_41777_(), 15, 15, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFillCount);
        if (sendOwnerNotice) {
            String orderFilledMessage;
            compoundNBT = new CompoundTag();
            Letter confirm = new Letter(this.address, new MailAddress(this.owner));
            if (ordersToFillCount == 1) {
                orderFilledMessage = Component.m_237115_((String)"for.gui.mail.order.filled.one").getString();
            } else {
                orderFilledMessage = Component.m_237115_((String)"for.gui.mail.order.filled.multiple").getString();
                orderFilledMessage = orderFilledMessage.replace("%COUNT", Integer.toString(ordersToFillCount));
            }
            orderFilledMessage = orderFilledMessage.replace("%SENDER", letter.getSender().getName());
            confirm.setText(orderFilledMessage);
            confirm.addStamps(MailItems.STAMPS.stack(EnumStampDefinition.P_1, 1));
            confirm.write(compoundNBT);
            ItemStack confirmstack = LetterProperties.createStampedLetterStack(confirm);
            confirmstack.m_41751_(compoundNBT);
            PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
            this.removePaper();
            this.removeStamps(new int[]{0, 1});
        }
        this.m_77762_();
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, ItemStack tradegood) {
        if (tradegood.m_41619_()) {
            return 0;
        }
        float orderCount = 0.0f;
        for (ItemStack stack : InventoryUtil.getStacks((Container)this.inventory, 30, 10)) {
            if (stack == null || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)tradegood) || !((orderCount += (float)stack.m_41613_() / (float)tradegood.m_41613_()) >= (float)max)) continue;
            return max;
        }
        return (int)Math.floor(orderCount);
    }

    public boolean canReceivePayment() {
        InventoryAdapter test = this.inventory.copy();
        NonNullList<ItemStack> payment = InventoryUtil.getStacks((Container)this.inventory, 1, 4);
        return InventoryUtil.tryAddStacksCopy((Container)test, payment, 15, 15, true);
    }

    private int countStorablePayment(int max, NonNullList<ItemStack> exchange) {
        InventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && InventoryUtil.tryAddStacksCopy((Container)test, exchange, 15, 15, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        for (int j = 0; j < filled; ++j) {
            ItemStack decrease;
            ItemStack buffer;
            int toRemove = this.inventory.m_8020_(0).m_41613_();
            for (int i = 30; i < 40 && ((buffer = this.inventory.m_8020_(i)).m_41619_() || !ItemStack.m_150942_((ItemStack)buffer, (ItemStack)this.inventory.m_8020_(0)) || (toRemove -= (decrease = this.inventory.m_7407_(i, toRemove)).m_41613_()) > 0); ++i) {
            }
        }
    }

    private boolean hasPaper(int amountRequired) {
        int amountFound = 0;
        for (ItemStack stack : InventoryUtil.getStacks((Container)this.inventory, 5, 6)) {
            if (stack != null) {
                amountFound += stack.m_41613_();
            }
            if (amountFound < amountRequired) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41720_() != Items.f_42516_) continue;
            this.inventory.m_7407_(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((Container)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.m_41720_() instanceof IStamps) || (posted += ((IStamps)stamp.m_41720_()).getPostage(stamp).getValue() * stamp.m_41613_()) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postageRequired, boolean virtual) {
        int num;
        EnumPostage postValue;
        int i;
        int[] stamps = new int[EnumPostage.values().length];
        int postageRemaining = postageRequired;
        for (i = EnumPostage.values().length - 1; i > 0 && postageRemaining > 0; --i) {
            postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postageRemaining) continue;
            num = virtual ? 99 : this.getNumStamps(postValue);
            int max = (int)Math.floor(postageRemaining / postValue.getValue());
            if (max < num) {
                num = max;
            }
            stamps[i] = num;
            postageRemaining -= num * postValue.getValue();
        }
        if (postageRemaining > 0) {
            for (i = 0; i < EnumPostage.values().length; ++i) {
                postValue = EnumPostage.values()[i];
                if (postValue.getValue() < postageRequired) continue;
                stamps = new int[EnumPostage.values().length];
                int n = num = virtual ? 99 : this.getNumStamps(postValue);
                if (num <= 0) continue;
                stamps[i] = 1;
                return stamps;
            }
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (ItemStack stamp : InventoryUtil.getStacks((Container)this.inventory, 11, 4)) {
            if (stamp == null || !(stamp.m_41720_() instanceof IStamps) || ((IStamps)stamp.m_41720_()).getPostage(stamp) != postage) continue;
            count += stamp.m_41613_();
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                ItemStack stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.m_8020_(j)).m_41619_() || !(stamp.m_41720_() instanceof IStamps) || ((IStamps)stamp.m_41720_()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                ItemStack decrease = this.inventory.m_7407_(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.m_41613_();
            }
        }
    }

    private NonNullList<ItemStack> getSurplusAttachments(int filled, NonNullList<ItemStack> attachments) {
        int i;
        NonNullList surplus = NonNullList.m_122779_();
        NonNullList pool = NonNullList.m_122780_((int)attachments.size(), (Object)ItemStack.f_41583_);
        for (i = 0; i < attachments.size(); ++i) {
            ItemStack attachment = (ItemStack)attachments.get(i);
            if (attachment.m_41619_()) continue;
            pool.set(i, (Object)attachment.m_41777_());
        }
        for (i = 0; i < filled; ++i) {
            NonNullList<ItemStack> required = InventoryUtil.getStacks((Container)this.inventory, 1, 4);
            List<ItemStack> condensedRequired = ItemStackUtil.condenseStacks(required);
            for (ItemStack req : condensedRequired) {
                for (int j = 0; j < pool.size(); ++j) {
                    ItemStack pol = (ItemStack)pool.get(j);
                    if (pol.m_41619_() || !ItemStack.m_41656_((ItemStack)pol, (ItemStack)req)) continue;
                    if (req.m_41613_() >= pol.m_41613_()) {
                        req.m_41774_(pol.m_41613_());
                        pool.set(j, (Object)ItemStack.f_41583_);
                        continue;
                    }
                    pol.m_41774_(req.m_41613_());
                    req.m_41764_(0);
                }
            }
        }
        for (ItemStack stack : pool) {
            if (stack == null) continue;
            surplus.add((Object)stack);
        }
        return surplus;
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public void m_77762_() {
        super.m_77762_();
        this.inventory.m_6596_();
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        this.m_77762_();
        this.inventory.m_6836_(slot, itemStack);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int var1) {
        return this.inventory.m_8020_(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return this.inventory.m_7407_(var1, var2);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int i, ItemStack itemStack) {
        return this.inventory.m_7013_(i, itemStack);
    }

    public int[] m_7071_(Direction side) {
        return this.inventory.m_7071_(side);
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction side) {
        return this.inventory.m_7155_(slot, itemStack, side);
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction side) {
        return this.inventory.m_7157_(slot, itemStack, side);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        return this.inventory.canSlotAccept(slotIndex, stack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.inventory.isLocked(slotIndex);
    }

    public void m_6211_() {
    }
}

