/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.mojang.authlib.GameProfile;
import forestry.Forestry;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostRegistry;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.PlayerUtil;
import forestry.mail.Letter;
import forestry.mail.LetterProperties;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.features.MailItems;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PostRegistry
implements IPostRegistry {
    @Nullable
    public static PostOffice cachedPostOffice;
    public static final Map<IMailAddress, POBox> cachedPOBoxes;
    public static final Map<IMailAddress, ITradeStation> cachedTradeStations;
    private final Map<EnumAddressee, IPostalCarrier> carriers = new EnumMap<EnumAddressee, IPostalCarrier>(EnumAddressee.class);

    @Override
    public boolean isValidPOBox(Level world, IMailAddress address) {
        return address.getType() == EnumAddressee.PLAYER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Nullable
    public static POBox getPOBox(ServerLevel world, IMailAddress address) {
        if (cachedPOBoxes.containsKey(address)) {
            return cachedPOBoxes.get(address);
        }
        POBox pobox = (POBox)world.m_8895_().m_164861_(POBox::new, () -> new POBox(address), "pobox_" + address);
        cachedPOBoxes.put(address, pobox);
        return pobox;
    }

    public static POBox getOrCreatePOBox(ServerLevel world, IMailAddress add) {
        POBox pobox = PostRegistry.getPOBox(world, add);
        if (pobox == null) {
            pobox = (POBox)world.m_8895_().m_164861_(POBox::new, () -> new POBox(add), "pobox_" + add);
            pobox.m_77762_();
            cachedPOBoxes.put(add, pobox);
            Player player = PlayerUtil.getPlayer((Level)world, add.getPlayerProfile());
            if (player != null) {
                NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(pobox.getPOBoxInfo()), (ServerPlayer)player);
            }
        }
        return pobox;
    }

    @Override
    public boolean isValidTradeAddress(Level world, IMailAddress address) {
        return address.getType() == EnumAddressee.TRADER && address.getName().matches("^[a-zA-Z0-9]+$");
    }

    @Override
    public boolean isAvailableTradeAddress(ServerLevel world, IMailAddress address) {
        return this.getTradeStation(world, address) == null;
    }

    @Override
    public TradeStation getTradeStation(ServerLevel world, IMailAddress address) {
        if (cachedTradeStations.containsKey(address)) {
            return (TradeStation)cachedTradeStations.get(address);
        }
        TradeStation trade = (TradeStation)world.m_8895_().m_164861_(TradeStation::new, () -> new TradeStation(null, address), "trade_po_" + address);
        if (trade.isValid()) {
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    @Override
    public TradeStation getOrCreateTradeStation(ServerLevel world, GameProfile owner, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            trade = (TradeStation)world.m_8895_().m_164861_(TradeStation::new, () -> new TradeStation(owner, address), "trade_po_" + address);
            trade.m_77762_();
            cachedTradeStations.put(address, trade);
            this.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    @Override
    public void deleteTradeStation(ServerLevel world, IMailAddress address) {
        TradeStation trade = this.getTradeStation(world, address);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(address);
        this.getPostOffice(world).deregisterTradeStation(trade);
        boolean delete = false;
        if (!delete) {
            Forestry.LOGGER.error("Failed to delete trade station file. {}", (Object)"FIXME!");
        }
    }

    @Override
    public IPostOffice getPostOffice(ServerLevel world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.m_8895_().m_164861_(PostOffice::new, PostOffice::new, "forestry_mail");
        office.setWorld(world);
        cachedPostOffice = office;
        return office;
    }

    @Override
    public IMailAddress getMailAddress(GameProfile gameProfile) {
        return new MailAddress(gameProfile);
    }

    @Override
    public IMailAddress getMailAddress(String traderName) {
        return new MailAddress(traderName);
    }

    @Override
    public Map<EnumAddressee, IPostalCarrier> getRegisteredCarriers() {
        return this.carriers;
    }

    @Override
    public void registerCarrier(IPostalCarrier carrier) {
        this.carriers.put(carrier.getType(), carrier);
    }

    @Override
    public IPostalCarrier getCarrier(EnumAddressee type) {
        return this.carriers.get((Object)type);
    }

    @Override
    public ILetter createLetter(IMailAddress sender, IMailAddress recipient) {
        return new Letter(sender, recipient);
    }

    @Override
    public ItemStack createLetterStack(ILetter letter) {
        CompoundTag compoundNBT = new CompoundTag();
        letter.write(compoundNBT);
        ItemStack letterStack = LetterProperties.createStampedLetterStack(letter);
        letterStack.m_41751_(compoundNBT);
        return letterStack;
    }

    @Override
    @Nullable
    public ILetter getLetter(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return null;
        }
        if (!PostManager.postRegistry.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.m_41783_() == null) {
            return null;
        }
        return new Letter(itemstack.m_41783_());
    }

    @Override
    public boolean isLetter(ItemStack itemstack) {
        return MailItems.LETTERS.itemEqual(itemstack);
    }

    static {
        cachedPOBoxes = new HashMap<IMailAddress, POBox>();
        cachedTradeStations = new HashMap<IMailAddress, ITradeStation>();
    }
}

