/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.google.common.base.Preconditions;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.POBoxInfo;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class POBox
extends SavedData
implements Container {
    public static final String SAVE_NAME = "pobox_";
    public static final short SLOT_SIZE = 84;
    @Nullable
    private IMailAddress address;
    private final InventoryAdapter letters = new InventoryAdapter(84, "Letters").disableAutomation();

    public POBox(IMailAddress address) {
        if (address.getType() != EnumAddressee.PLAYER) {
            throw new IllegalArgumentException("POBox address must be a player");
        }
        this.address = address;
    }

    public POBox(CompoundTag tag) {
        if (tag.m_128441_("address")) {
            this.address = new MailAddress(tag.m_128469_("address"));
        }
        this.letters.read(tag);
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        if (this.address != null) {
            CompoundTag nbt = new CompoundTag();
            this.address.write(nbt);
            compoundNBT.m_128365_("address", (Tag)nbt);
        }
        this.letters.write(compoundNBT);
        return compoundNBT;
    }

    public boolean storeLetter(ItemStack letterstack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        Preconditions.checkNotNull((Object)letter, (Object)"Letter stack must be a valid letter");
        letter.setProcessed(true);
        letter.invalidatePostage();
        CompoundTag compoundNBT = new CompoundTag();
        letter.write(compoundNBT);
        letterstack.m_41751_(compoundNBT);
        this.m_77762_();
        return InventoryUtil.tryAddStack((Container)this.letters, letterstack, true);
    }

    public POBoxInfo getPOBoxInfo() {
        int playerLetters = 0;
        int tradeLetters = 0;
        for (int i = 0; i < this.letters.m_6643_(); ++i) {
            CompoundTag tagCompound;
            if (this.letters.m_8020_(i).m_41619_() || (tagCompound = this.letters.m_8020_(i).m_41783_()) == null) continue;
            Letter letter = new Letter(tagCompound);
            if (letter.getSender().getType() == EnumAddressee.PLAYER) {
                ++playerLetters;
                continue;
            }
            ++tradeLetters;
        }
        return new POBoxInfo(playerLetters, tradeLetters);
    }

    public boolean m_7983_() {
        return this.letters.m_7983_();
    }

    public void m_77762_() {
        super.m_77762_();
        this.letters.m_6596_();
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.m_77762_();
        this.letters.m_6836_(var1, var2);
    }

    public int m_6643_() {
        return this.letters.m_6643_();
    }

    public ItemStack m_8020_(int var1) {
        return this.letters.m_8020_(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return this.letters.m_7407_(var1, var2);
    }

    public ItemStack m_8016_(int index) {
        return this.letters.m_8016_(index);
    }

    public int m_6893_() {
        return this.letters.m_6893_();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player var1) {
        return this.letters.m_6542_(var1);
    }

    public void m_5856_(Player var1) {
    }

    public void m_5785_(Player var1) {
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return this.letters.m_7013_(i, itemstack);
    }

    public void m_6211_() {
    }
}

