/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.mail.MailAddress;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class Letter
implements ILetter {
    private static final Random rand = new Random();
    public static final short SLOT_ATTACHMENT_1 = 0;
    public static final short SLOT_ATTACHMENT_COUNT = 18;
    public static final short SLOT_POSTAGE_1 = 18;
    public static final short SLOT_POSTAGE_COUNT = 4;
    private boolean isProcessed = false;
    private IMailAddress sender;
    @Nullable
    private IMailAddress recipient;
    private String text = "";
    private final InventoryAdapter inventory = new InventoryAdapter(22, "INV");
    private final int uid;

    public Letter(IMailAddress sender, IMailAddress recipient) {
        this.sender = sender;
        this.recipient = recipient;
        this.uid = rand.nextInt();
    }

    public Letter(CompoundTag compoundNBT) {
        this.isProcessed = compoundNBT.m_128471_("PRC");
        this.sender = new MailAddress(compoundNBT.m_128469_("SDR"));
        this.recipient = new MailAddress(compoundNBT.m_128469_("RC"));
        this.text = compoundNBT.m_128461_("TXT");
        this.uid = compoundNBT.m_128451_("UID");
        this.inventory.read(compoundNBT);
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128379_("PRC", this.isProcessed);
        CompoundTag subcompound = new CompoundTag();
        this.sender.write(subcompound);
        compoundNBT.m_128365_("SDR", (Tag)subcompound);
        if (this.recipient != null) {
            subcompound = new CompoundTag();
            this.recipient.write(subcompound);
            compoundNBT.m_128365_("RC", (Tag)subcompound);
        }
        compoundNBT.m_128359_("TXT", this.text);
        compoundNBT.m_128405_("UID", this.uid);
        this.inventory.write(compoundNBT);
        return compoundNBT;
    }

    @Override
    public NonNullList<ItemStack> getPostage() {
        return InventoryUtil.getStacks((Container)this.inventory, 18, 4);
    }

    @Override
    public NonNullList<ItemStack> getAttachments() {
        return InventoryUtil.getStacks((Container)this.inventory, 0, 18);
    }

    @Override
    public int countAttachments() {
        int count = 0;
        for (ItemStack stack : this.getAttachments()) {
            if (stack.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void addAttachment(ItemStack itemstack) {
        InventoryUtil.tryAddStack((Container)this.inventory, itemstack, false);
    }

    @Override
    public void addAttachments(NonNullList<ItemStack> itemstacks) {
        for (ItemStack stack : itemstacks) {
            this.addAttachment(stack);
        }
    }

    @Override
    public void invalidatePostage() {
        for (int i = 18; i < 22; ++i) {
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void setProcessed(boolean flag) {
        this.isProcessed = flag;
    }

    @Override
    public boolean isProcessed() {
        return this.isProcessed;
    }

    @Override
    public boolean isMailable() {
        return !this.isProcessed && this.recipient != null;
    }

    @Override
    public boolean isPostPaid() {
        int posted = 0;
        for (ItemStack stamp : this.getPostage()) {
            if (stamp.m_41619_() || !(stamp.m_41720_() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.m_41720_()).getPostage(stamp).getValue() * stamp.m_41613_();
        }
        return posted >= this.requiredPostage();
    }

    @Override
    public int requiredPostage() {
        int required = 1;
        for (ItemStack attach : this.getAttachments()) {
            if (attach.m_41619_()) continue;
            ++required;
        }
        return required;
    }

    @Override
    public void addStamps(ItemStack stamps) {
        InventoryUtil.tryAddStack((Container)this.inventory, stamps, 18, 4, false);
    }

    @Override
    public boolean hasRecipient() {
        return this.recipient != null && !StringUtils.isBlank((CharSequence)this.recipient.getName());
    }

    @Override
    public void setSender(IMailAddress address) {
        this.sender = address;
    }

    @Override
    public IMailAddress getSender() {
        return this.sender;
    }

    @Override
    public void setRecipient(@Nullable IMailAddress address) {
        this.recipient = address;
    }

    @Override
    @Nullable
    public IMailAddress getRecipient() {
        return this.recipient;
    }

    @Override
    public String getRecipientString() {
        if (this.recipient == null) {
            return "";
        }
        return this.recipient.getName();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void addTooltip(List<Component> list) {
        if (StringUtils.isNotBlank((CharSequence)this.sender.getName())) {
            list.add((Component)Component.m_237115_((String)"for.gui.mail.from").m_130946_(": " + this.sender.getName()).m_130940_(ChatFormatting.GRAY));
        }
        if (this.recipient != null) {
            list.add((Component)Component.m_237115_((String)"for.gui.mail.to").m_130946_(": " + this.getRecipientString()).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int var1) {
        return this.inventory.m_8020_(var1);
    }

    public ItemStack m_7407_(int var1, int var2) {
        return this.inventory.m_7407_(var1, var2);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public void m_6836_(int var1, ItemStack var2) {
        this.inventory.m_6836_(var1, var2);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public void m_6596_() {
        this.inventory.m_6596_();
    }

    public boolean m_6542_(Player var1) {
        return true;
    }

    public void m_5856_(Player var1) {
        this.inventory.m_5856_(var1);
    }

    public void m_5785_(Player var1) {
        this.inventory.m_5785_(var1);
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return this.inventory.m_7013_(i, itemstack);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }
}

