/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.worldgen;

import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.blocks.BlockSolidCocoon;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.tiles.TileCocoon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CocoonDecorator
extends Feature<NoneFeatureConfiguration> {
    public CocoonDecorator() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public static boolean genCocoon(WorldGenLevel world, RandomSource rand, BlockPos pos, IButterfly butterfly) {
        if (butterfly.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getRarity() * ModuleLepidopterology.getGenerateCocoonsAmount() < rand.m_188501_() * 100.0f) {
            return false;
        }
        TagKey<Biome> spawnBiomes = butterfly.getGenome().getActiveValue(ButterflyChromosomes.SPECIES).getSpawnBiomes();
        if (world.m_204166_(pos).m_203656_(spawnBiomes)) {
            for (int tries = 0; tries < 4; ++tries) {
                int z;
                int x = pos.m_123341_() + rand.m_188503_(16);
                if (!CocoonDecorator.tryGenCocoon(world, x, z = pos.m_123343_() + rand.m_188503_(16), butterfly)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean tryGenCocoon(WorldGenLevel level, int x, int z, IButterfly butterfly) {
        BlockPos pos = CocoonDecorator.getPosForCocoon(level, x, z);
        if (pos != null && CocoonDecorator.isValidLocation(level, pos)) {
            return CocoonDecorator.setCocoon(level, pos, butterfly);
        }
        return false;
    }

    private static boolean setCocoon(WorldGenLevel world, BlockPos pos, IButterfly butterfly) {
        BlockSolidCocoon cocoonBlock = LepidopterologyBlocks.COCOON_SOLID.block();
        boolean placed = world.m_7731_(pos, cocoonBlock.m_49966_(), 2);
        if (!placed) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (cocoonBlock != state.m_60734_()) {
            return false;
        }
        TileCocoon cocoon = TileUtil.getTile((BlockGetter)world, pos, TileCocoon.class);
        if (cocoon == null) {
            return false;
        }
        cocoon.setCaterpillar(butterfly);
        cocoonBlock.m_6807_(state, (Level)world.m_6018_(), pos, cocoonBlock.m_49966_(), false);
        world.m_6018_().m_6550_(pos, state, cocoonBlock.m_49966_());
        return true;
    }

    @Nullable
    private static BlockPos getPosForCocoon(WorldGenLevel world, int x, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
        BlockState state = world.m_8055_((BlockPos)pos);
        if (!state.m_204336_(BlockTags.f_13035_)) {
            return null;
        }
        do {
            pos.m_122184_(0, -1, 0);
        } while ((state = world.m_8055_((BlockPos)pos)).m_204336_(BlockTags.f_13035_));
        return pos;
    }

    public static boolean isValidLocation(WorldGenLevel world, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        if (!aboveState.m_204336_(BlockTags.f_13035_)) {
            return false;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockState blockStateBelow = world.m_8055_(posBelow);
        return BlockUtil.canReplace(blockStateBelow, (LevelAccessor)world, posBelow);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        ObjectArrayList butterflies = new ObjectArrayList(((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getAllSpecies());
        Util.m_214673_((ObjectArrayList)butterflies, (RandomSource)context.m_225041_());
        for (IButterflySpecies butterfly : butterflies) {
            if (!CocoonDecorator.genCocoon(context.m_159774_(), context.m_225041_(), context.m_159777_(), (IButterfly)butterfly.createIndividual())) continue;
            return true;
        }
        return false;
    }
}

