/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerRecipe
implements ISqueezerRecipe {
    private final ResourceLocation id;
    private final int processingTime;
    private final List<Ingredient> resources;
    private final FluidStack fluidOutput;
    private final ItemStack remnants;
    private final float remnantsChance;

    public SqueezerRecipe(ResourceLocation id, int processingTime, List<Ingredient> resources, FluidStack fluidOutput, ItemStack remnants, float remnantsChance) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull(resources);
        Preconditions.checkArgument((!resources.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)fluidOutput);
        Preconditions.checkNotNull((Object)remnants);
        this.id = id;
        this.processingTime = processingTime;
        this.resources = resources;
        this.fluidOutput = fluidOutput;
        this.remnants = remnants;
        this.remnantsChance = remnantsChance;
    }

    @Override
    public List<Ingredient> getInputs() {
        return this.resources;
    }

    @Override
    public ItemStack getRemnants() {
        return this.remnants;
    }

    @Override
    public float getRemnantsChance() {
        return this.remnantsChance;
    }

    @Override
    public FluidStack getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.SQUEEZER.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.SQUEEZER.type();
    }

    public static class Serializer
    implements RecipeSerializer<SqueezerRecipe> {
        public SqueezerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processingTime = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            ArrayList<Ingredient> resources = new ArrayList<Ingredient>();
            FluidStack fluidOutput = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            ItemStack remnants = RecipeSerializers.item(GsonHelper.m_13930_((JsonObject)json, (String)"remnant"));
            float remnantsChance = GsonHelper.m_13915_((JsonObject)json, (String)"chance");
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"resources")) {
                resources.add(RecipeSerializers.deserialize(element));
            }
            return new SqueezerRecipe(recipeId, processingTime, resources, fluidOutput, remnants, remnantsChance);
        }

        public SqueezerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int processingTime = buffer.m_130242_();
            List<Ingredient> resources = RecipeSerializers.read(buffer, Ingredient::m_43940_);
            FluidStack fluidOutput = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack remnants = buffer.m_130267_();
            float remnantsChance = buffer.readFloat();
            return new SqueezerRecipe(recipeId, processingTime, resources, fluidOutput, remnants, remnantsChance);
        }

        public void toNetwork(FriendlyByteBuf buffer, SqueezerRecipe recipe) {
            buffer.m_130130_(recipe.processingTime);
            RecipeSerializers.write(buffer, recipe.resources, (packetBuffer, ingredient) -> ingredient.m_43923_(packetBuffer));
            recipe.fluidOutput.writeToPacket(buffer);
            buffer.m_130055_(recipe.remnants);
            buffer.writeFloat(recipe.remnantsChance);
        }
    }
}

