/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.core.network.IStreamableGui;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileBase;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.ForestryEnergyStorage;
import forestry.energy.blocks.EngineBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EngineBlockEntity
extends TileBase
implements IActivatable,
IStreamableGui {
    private static final int CANT_SEND_ENERGY_TIME = 20;
    private boolean active = false;
    private int cantSendEnergyCountdown = 20;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    protected int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected final ForestryEnergyStorage energyStorage;
    private final LazyOptional<IEnergyStorage> energyCap;
    private final String hintKey;

    protected EngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, String hintKey, int maxHeat, int maxEnergy) {
        super(type, pos, state);
        this.hintKey = hintKey;
        this.maxHeat = maxHeat;
        this.energyStorage = new ForestryEnergyStorage(2000, maxEnergy, EnergyTransferMode.EXTRACT);
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
    }

    public String getHintKey() {
        return this.hintKey;
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    protected abstract void dissipateHeat();

    protected abstract void generateHeat();

    protected boolean mayBurn() {
        return !this.forceCooldown;
    }

    protected abstract void burn();

    @Override
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.active) {
            this.stagePiston = 1;
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(this.forceCooldown, ForestryError.FORCED_COOLDOWN);
        boolean enabledRedstone = this.isRedstoneActivated();
        errorLogic.setCondition(!enabledRedstone, ForestryError.NO_REDSTONE);
        BlockState blockState = this.m_58900_();
        Direction facing = (Direction)blockState.m_61143_(EngineBlock.VERTICAL_FACING);
        BlockEntity tile = level.m_7702_(this.m_58899_().m_121945_(facing));
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            EnergyHelper.sendEnergy(this.energyStorage, facing, tile);
            if ((double)this.progress > 0.25 && this.stagePiston == 1) {
                this.stagePiston = 2;
            } else if ((double)this.progress >= 0.5) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (enabledRedstone && EnergyHelper.isEnergyReceiverOrEngine(facing.m_122424_(), tile)) {
            if (EnergyHelper.canSendEnergy(this.energyStorage, facing, tile)) {
                this.stagePiston = 1;
                this.setActive(true);
                this.cantSendEnergyCountdown = 20;
            } else if (this.isActive()) {
                --this.cantSendEnergyCountdown;
                if (this.cantSendEnergyCountdown <= 0) {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.energyStorage.drainEnergy(20);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.f_58857_.f_46443_) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.f_58858_, this.f_58857_);
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    protected abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isRedstoneActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        return TemperatureState.getState(this.heat, this.maxHeat);
    }

    protected float getPistonSpeed() {
        return switch (this.getTemperatureState()) {
            case TemperatureState.COOL -> 0.03f;
            case TemperatureState.WARMED_UP -> 0.04f;
            case TemperatureState.OPERATING_TEMPERATURE -> 0.05f;
            case TemperatureState.RUNNING_HOT -> 0.06f;
            case TemperatureState.OVERHEATING -> 0.07f;
            case TemperatureState.MELTING -> 0.08f;
            default -> 0.0f;
        };
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.read(nbt);
        this.heat = nbt.m_128451_("EngineHeat");
        this.progress = nbt.m_128457_("EngineProgress");
        this.forceCooldown = nbt.m_128471_("ForceCooldown");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.energyStorage.write(nbt);
        nbt.m_128405_("EngineHeat", this.heat);
        nbt.m_128350_("EngineProgress", this.progress);
        nbt.m_128379_("ForceCooldown", this.forceCooldown);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        data.writeBoolean(this.active);
        data.writeInt(this.heat);
        data.writeFloat(this.pistonSpeedServer);
        this.energyStorage.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        super.readData(data);
        this.active = data.readBoolean();
        this.heat = data.readInt();
        this.pistonSpeedServer = data.readFloat();
        this.energyStorage.readData(data);
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        data.writeInt(this.currentOutput);
        data.writeInt(this.heat);
        data.writeBoolean(this.forceCooldown);
        this.energyStorage.writeData(data);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        this.currentOutput = data.readInt();
        this.heat = data.readInt();
        this.forceCooldown = data.readBoolean();
        this.energyStorage.readData(data);
    }

    public ForestryEnergyStorage getEnergyManager() {
        return this.energyStorage;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ENERGY && side == this.m_58900_().m_61143_(EngineBlock.VERTICAL_FACING)) {
            return this.energyCap.cast();
        }
        return super.getCapability(capability, side);
    }
}

