/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.datastructures;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class StackMap<P, T>
extends HashMap<P, T> {
    private static final long serialVersionUID = 5383477742290646466L;

    @Override
    public final T put(P key, T value) {
        Preconditions.checkArgument((boolean)this.isValidKey(key), (Object)"Key is invalid");
        Preconditions.checkNotNull(value);
        return super.put(key, value);
    }

    @Override
    public final boolean containsKey(Object key) {
        P stack = this.getStack(key);
        if (stack == null) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!this.areEqual(stack, entry.getKey())) continue;
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    @Nullable
    public final T get(Object key) {
        P stack = this.getStack(key);
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!this.areEqual(stack, entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return (T)super.get(key);
    }

    protected abstract boolean areEqual(P var1, P var2);

    protected abstract boolean isValidKey(Object var1);

    @Nullable
    protected abstract P getStack(Object var1);
}

