/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.datastructures;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateSet
extends AbstractSet<BlockState> {
    private final Set<BlockState> blockStates = new HashSet<BlockState>();
    private final Map<Block, Integer> blocks = new IdentityHashMap<Block, Integer>();

    @Override
    public boolean add(BlockState blockState) {
        Block block = blockState.m_60734_();
        Integer count = this.blocks.getOrDefault(block, 0);
        this.blocks.put(block, count + 1);
        return this.blockStates.add(blockState);
    }

    @Override
    public boolean remove(Object o) {
        BlockState blockState = (BlockState)o;
        Block block = blockState.m_60734_();
        Integer count = this.blocks.getOrDefault(block, 0);
        if (count > 0) {
            this.blocks.put(block, count - 1);
        } else {
            this.blocks.remove(block);
        }
        return this.blockStates.remove(blockState);
    }

    @Override
    public boolean contains(Object o) {
        BlockState blockState = (BlockState)o;
        Block block = blockState.m_60734_();
        return this.blocks.containsKey(block) && this.blockStates.contains(blockState);
    }

    @Override
    public void clear() {
        this.blockStates.clear();
        this.blocks.clear();
    }

    @Override
    public Iterator<BlockState> iterator() {
        return this.blockStates.iterator();
    }

    @Override
    public int size() {
        return this.blockStates.size();
    }
}

