/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.tiles.TileUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final BlockEntity[] cache = new BlockEntity[6];
    private final int[] delay = new int[6];
    private final BlockEntity source;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentTileCache(BlockEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    @Nullable
    private BlockEntity searchSide(Direction side) {
        BlockPos pos;
        Level world = this.source.m_58904_();
        if (world.m_46805_(pos = this.source.m_58899_().m_121945_(side)) && !world.m_46859_(pos)) {
            return TileUtil.getTile((BlockGetter)world, pos);
        }
        return null;
    }

    public void refresh() {
        for (Direction side : Direction.values()) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(int side, @Nullable BlockEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    private void changed() {
        for (ICacheListener listener : this.listeners) {
            listener.changed();
        }
    }

    private boolean areCoordinatesOnSide(Direction side, BlockEntity target) {
        return this.source.m_58899_().m_123341_() + side.m_122429_() == target.m_58899_().m_123341_() && this.source.m_58899_().m_123342_() + side.m_122430_() == target.m_58899_().m_123342_() && this.source.m_58899_().m_123343_() + side.m_122431_() == target.m_58899_().m_123343_();
    }

    @Nullable
    public BlockEntity getTileOnSide(Direction side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].m_58901_() || !this.areCoordinatesOnSide(side, this.cache[s])) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.m_58904_(), this.delay[s])) {
            this.setTile(s, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public BlockEntity getSource() {
        return this.source;
    }

    private static class Timer {
        private long startTime = Long.MIN_VALUE;

        private Timer() {
        }

        public boolean hasTriggered(Level world, int ticks) {
            long currentTime = world.m_46467_();
            if (currentTime >= (long)ticks + this.startTime || this.startTime > currentTime) {
                this.startTime = currentTime;
                return true;
            }
            return false;
        }

        public void reset() {
            this.startTime = Long.MIN_VALUE;
        }
    }

    public static interface ICacheListener {
        public void changed();

        public void purge();
    }
}

