/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.utils.ResourceUtil;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class ModelBlockLayer<K>
extends ModelBlockCached<Block, K> {
    private final ModelProvider<K> provider;

    public ModelBlockLayer(ModelProvider<K> provider) {
        super(Block.class);
        this.provider = provider;
    }

    @Override
    protected K getInventoryKey(ItemStack stack) {
        return this.provider.getInventoryKey(stack);
    }

    @Override
    protected K getWorldKey(BlockState state, ModelData extraData) {
        return this.provider.getWorldKey(state, extraData);
    }

    @Override
    protected void bakeBlock(Block block, ModelData extraData, K key, ModelBaker baker, boolean inventory) {
        for (int layer = 0; layer < this.provider.getLayerCount(); ++layer) {
            TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
            for (Direction direction : Direction.f_122346_) {
                TextureAtlasSprite texture = this.provider.getSprite(key, direction, layer);
                textures[direction.m_122411_()] = texture != null ? texture : ResourceUtil.getMissingTexture();
            }
            baker.addBlockModel(textures, this.provider.getColorIndex(key, layer));
        }
        baker.setParticleSprite(this.provider.getParticle(key));
    }

    public static interface ModelProvider<K> {
        public K getInventoryKey(ItemStack var1);

        public K getWorldKey(BlockState var1, ModelData var2);

        default public int getLayerCount() {
            return 2;
        }

        @Nullable
        public TextureAtlasSprite getSprite(K var1, Direction var2, int var3);

        default public int getColorIndex(K data, int layer) {
            return layer;
        }

        public TextureAtlasSprite getParticle(K var1);
    }
}

