/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SoundUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GameTokenWidget
extends Widget {
    private final ItemStack HIDDEN_TOKEN = new ItemStack((ItemLike)Items.f_42517_);
    private final EscritoireGame game;
    private final int index;

    public GameTokenWidget(EscritoireGame game, WidgetManager manager, int xPos, int yPos, int index) {
        super(manager, xPos, yPos);
        this.game = game;
        this.index = index;
        this.width = 20;
        this.height = 20;
    }

    @Nullable
    private EscritoireGameToken getToken() {
        return this.game.getToken(this.index);
    }

    @Override
    public void draw(GuiGraphics graphics, int startX, int startY) {
        EscritoireGameToken token = this.getToken();
        if (token == null) {
            return;
        }
        int tokenColour = token.getTokenColour();
        float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(tokenColour & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        graphics.m_280218_(this.manager.gui.textureFile, startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack tokenStack = this.HIDDEN_TOKEN;
        if (token.isVisible()) {
            tokenStack = token.getTokenStack();
        }
        GuiUtil.drawItemStack(graphics, this.manager.gui, tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
        ResourceLocation overlayToken = token.getOverlayToken();
        if (overlayToken != null) {
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
            TextureAtlasSprite icon = IForestryClientApi.INSTANCE.getTextureManager().getSprite(overlayToken);
            graphics.m_280159_(startX + this.xPos + 3, startY + this.yPos + 3, 0, 16, 16, icon);
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        EscritoireGameToken token = this.getToken();
        if (token == null || !token.isVisible()) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(token.getTooltip());
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        this.game.choose(this.index);
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(this.index, 0));
        SoundUtil.playButtonClick();
    }
}

