/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.blaze3d.systems.RenderSystem;
import forestry.api.ForestryConstants;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.core.config.SessionVars;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.ledgers.LedgerManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class Ledger {
    public static final int guiTabSpeed = 8;
    protected static final int minWidth = 24;
    public static final int minHeight = 24;
    protected final int maxWidth;
    protected final int maxTextWidth;
    protected int maxHeight = 24;
    private static final ResourceLocation ledgerTextureRight = ForestryConstants.forestry("textures/gui/ledger.png");
    private static final ResourceLocation ledgerTextureLeft = ForestryConstants.forestry("textures/gui/ledger_left.png");
    protected final LedgerManager manager;
    private final int fontColorHeader;
    private final int fontColorText;
    private final int fontColorSubheader;
    private final int overlayColor;
    private boolean open;
    public int currentShiftX = 0;
    public int currentShiftY = 0;
    protected float currentWidth = 24.0f;
    protected float currentHeight = 24.0f;
    private int x;
    private int y;
    private final ResourceLocation texture;
    private static final float msPerUpdate = 16.667f;
    private long lastUpdateTime = 0L;

    protected Ledger(LedgerManager manager, String name) {
        this(manager, name, true);
    }

    protected Ledger(LedgerManager manager, String name, boolean rightSide) {
        this.manager = manager;
        this.texture = rightSide ? ledgerTextureRight : ledgerTextureLeft;
        this.fontColorHeader = manager.gui.getFontColor().get("ledger." + name + ".header");
        this.fontColorSubheader = manager.gui.getFontColor().get("ledger." + name + ".subheader");
        this.fontColorText = manager.gui.getFontColor().get("ledger." + name + ".text");
        this.overlayColor = manager.gui.getFontColor().get("ledger." + name + ".background");
        this.maxWidth = Math.min(124, manager.getMaxWidth());
        this.maxTextWidth = this.maxWidth - 18;
    }

    public Rect2i getArea() {
        GuiForestry<?> gui = this.manager.gui;
        return new Rect2i(gui.getGuiLeft() + this.x, gui.getGuiTop() + this.y, (int)this.currentWidth, (int)this.currentHeight);
    }

    public void update() {
        long updateTime;
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = System.currentTimeMillis();
            updateTime = this.lastUpdateTime + (long)Math.round(16.667f);
        } else {
            updateTime = System.currentTimeMillis();
        }
        float moveAmount = (float)(8L * (updateTime - this.lastUpdateTime)) / 16.667f;
        this.lastUpdateTime = updateTime;
        if (this.open && this.currentWidth < (float)this.maxWidth) {
            this.currentWidth += moveAmount;
            if (this.currentWidth > (float)this.maxWidth) {
                this.currentWidth = this.maxWidth;
            }
        } else if (!this.open && this.currentWidth > 24.0f) {
            this.currentWidth -= moveAmount;
            if (this.currentWidth < 24.0f) {
                this.currentWidth = 24.0f;
            }
        }
        if (this.open && this.currentHeight < (float)this.maxHeight) {
            this.currentHeight += moveAmount;
            if (this.currentHeight > (float)this.maxHeight) {
                this.currentHeight = this.maxHeight;
            }
        } else if (!this.open && this.currentHeight > 24.0f) {
            this.currentHeight -= moveAmount;
            if (this.currentHeight < 24.0f) {
                this.currentHeight = 24.0f;
            }
        }
    }

    public int getHeight() {
        return Math.round(this.currentHeight);
    }

    public int getWidth() {
        return Math.round(this.currentWidth);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final void draw(GuiGraphics graphics) {
        this.draw(graphics, this.y, this.x);
    }

    public abstract void draw(GuiGraphics var1, int var2, int var3);

    public abstract Component getTooltip();

    public boolean handleMouseClicked(double x, double y, int mouseButton) {
        return false;
    }

    public boolean intersects(double mouseX, double mouseY) {
        return mouseX >= (double)this.currentShiftX && mouseX <= (double)((float)this.currentShiftX + this.currentWidth) && mouseY >= (double)this.currentShiftY && mouseY <= (double)(this.currentShiftY + this.getHeight());
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            SessionVars.setOpenedLedger(null);
        } else {
            this.open = true;
            SessionVars.setOpenedLedger(this.getClass());
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isFullyOpened() {
        return this.currentWidth >= (float)this.maxWidth;
    }

    public void onGuiClosed() {
    }

    protected void drawBackground(GuiGraphics graphics, int y, int x) {
        float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int height = this.getHeight();
        int width = this.getWidth();
        graphics.m_280218_(this.texture, x, y + 4, 0, 256 - height + 4, 4, height - 4);
        graphics.m_280218_(this.texture, x + 4, y, 256 - width + 4, 0, width - 4, 4);
        graphics.m_280218_(this.texture, x, y, 0, 0, 4, 4);
        graphics.m_280218_(this.texture, x + 4, y + 4, 256 - width + 4, 256 - height + 4, width - 4, height - 4);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawSprite(GuiGraphics graphics, ResourceLocation path, int x, int y) {
        this.drawSprite(graphics, IForestryClientApi.INSTANCE.getTextureManager().getSprite(path), x, y);
    }

    protected void drawSprite(GuiGraphics graphics, TextureAtlasSprite sprite, int x, int y) {
        this.drawSprite(graphics, sprite, x, y, ForestrySprites.TEXTURE_ATLAS);
    }

    protected void drawSprite(GuiGraphics graphics, TextureAtlasSprite sprite, int x, int y, ResourceLocation textureMap) {
        graphics.m_280159_(x, y, 0, 16, 16, sprite);
    }

    protected int drawHeader(GuiGraphics graphics, Component string, int x, int y) {
        return this.drawShadowText(graphics, string, x, y, this.fontColorHeader);
    }

    protected int drawSubheader(GuiGraphics graphics, Component string, int x, int y) {
        return this.drawShadowText(graphics, string, x, y, this.fontColorSubheader);
    }

    protected int drawShadowText(GuiGraphics graphics, Component string, int x, int y, int color) {
        return this.drawSplitText(graphics, string, x, y, this.maxTextWidth, color, true);
    }

    protected int drawSplitText(GuiGraphics graphics, Component string, int x, int y, int width) {
        return this.drawSplitText(graphics, string, x, y, width, this.fontColorText, false);
    }

    protected int drawSplitText(GuiGraphics graphics, Component string, int x, int y, int width, int color, boolean shadow) {
        int originalY = y;
        Minecraft mc = Minecraft.m_91087_();
        List strings = mc.f_91062_.m_92923_((FormattedText)string, width);
        for (FormattedCharSequence obj : strings) {
            graphics.m_280649_(mc.f_91062_, obj, x, y, color, shadow);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
        }
        return y - originalY;
    }

    protected int drawText(GuiGraphics graphics, String string, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        graphics.m_280056_(mc.f_91062_, string, x, y, this.fontColorText, false);
        Objects.requireNonNull(mc.f_91062_);
        return 9;
    }
}

