/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data;

import com.google.common.collect.Streams;
import forestry.api.ForestryTags;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.CharcoalBlocks;
import forestry.core.blocks.EnumResourceType;
import forestry.core.features.CoreBlocks;
import forestry.energy.features.EnergyBlocks;
import forestry.factory.features.FactoryBlocks;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.blocks.FarmBlock;
import forestry.farming.features.FarmingBlocks;
import forestry.mail.features.MailBlocks;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureBlockGroup;
import forestry.worktable.features.WorktableBlocks;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import thedarkcolour.modkit.data.MKTagsProvider;

public final class ForestryBlockTagsProvider {
    public static void addTags(MKTagsProvider<Block> tags, HolderLookup.Provider lookup) {
        tags.tag(ForestryTags.Blocks.MINEABLE_SCOOP).add((Object[])ApicultureBlocks.BEEHIVE.blockArray());
        tags.tag(ForestryTags.Blocks.MINEABLE_GRAFTER).addTag(BlockTags.f_13035_);
        for (EnumFarmMaterial material : EnumFarmMaterial.values()) {
            tags.tag(ForestryTags.Blocks.VALID_FARM_BASE).add((Object)material.getBase());
        }
        tags.tag(ForestryTags.Blocks.VALID_FARM_BASE).add((Object)Blocks.f_50470_);
        tags.tag(BlockTags.f_144280_).add((Object[])CoreBlocks.NATURALIST_CHEST.blockArray()).add((Object)CharcoalBlocks.LOG_PILE.block()).add((Object)WorktableBlocks.WORKTABLE.block());
        tags.tag(BlockTags.f_144282_).add((Object)CoreBlocks.APATITE_ORE.block()).add((Object)CoreBlocks.DEEPSLATE_APATITE_ORE.block()).add((Object)CoreBlocks.TIN_ORE.block()).add((Object)CoreBlocks.DEEPSLATE_TIN_ORE.block()).add((Object)CoreBlocks.RAW_TIN_BLOCK.block()).add((Object)CharcoalBlocks.CHARCOAL.block()).add((Object[])EnergyBlocks.ENGINES.blockArray());
        for (FarmBlock block : FarmingBlocks.FARM.getBlocks()) {
            tags.tag(BlockTags.f_144282_).add((Object)block);
        }
        for (Block block : ForestryBlockTagsProvider.union(CoreBlocks.RESOURCE_STORAGE, FactoryBlocks.PLAIN, FactoryBlocks.TESR, MailBlocks.BASE)) {
            tags.tag(BlockTags.f_144282_).add((Object)block);
        }
        tags.tag(BlockTags.f_144283_).add((Object)CoreBlocks.HUMUS.block()).add((Object)CoreBlocks.BOG_EARTH.block()).add((Object)CoreBlocks.PEAT.block());
        for (Block block : ForestryBlockTagsProvider.union(CoreBlocks.BASE, ApicultureBlocks.ALVEARY, ApicultureBlocks.BASE, ArboricultureBlocks.DOORS, ArboricultureBlocks.PLANKS, ArboricultureBlocks.PLANKS_FIREPROOF, ArboricultureBlocks.PLANKS_VANILLA_FIREPROOF, ArboricultureBlocks.LOGS, ArboricultureBlocks.LOGS_FIREPROOF, ArboricultureBlocks.LOGS_VANILLA_FIREPROOF, ArboricultureBlocks.STRIPPED_LOGS, ArboricultureBlocks.STRIPPED_WOOD, ArboricultureBlocks.STRIPPED_LOGS_FIREPROOF, ArboricultureBlocks.STRIPPED_WOOD_FIREPROOF, ArboricultureBlocks.FENCES, ArboricultureBlocks.FENCES_FIREPROOF, ArboricultureBlocks.FENCES_VANILLA_FIREPROOF)) {
            tags.tag(BlockTags.f_144280_).add((Object)block);
        }
        tags.tag(BlockTags.f_144282_).addTag(ForestryTags.Blocks.ORES_TIN).addTag(ForestryTags.Blocks.ORES_APATITE).addTag(ForestryTags.Blocks.STORAGE_BLOCKS_RAW_TIN);
        tags.tag(BlockTags.f_144286_).addTag(ForestryTags.Blocks.ORES_TIN).addTag(ForestryTags.Blocks.ORES_APATITE).addTag(ForestryTags.Blocks.STORAGE_BLOCKS_RAW_TIN);
        tags.tag(ForestryTags.Blocks.CHARCOAL_BLOCK).add((Object)CharcoalBlocks.CHARCOAL.block());
        tags.tag(Tags.Blocks.CHESTS).add((Object[])((Block[])CoreBlocks.NATURALIST_CHEST.getBlocks().toArray(Block[]::new)));
        tags.tag(BlockTags.f_13090_).add((Object[])ArboricultureBlocks.PLANKS.blockArray());
        for (ForestryWoodType woodType : ForestryWoodType.VALUES) {
            tags.tag(woodType.blockTag).add((Object[])((Block[])Streams.concat((Stream[])new Stream[]{woodType.getFireproof(), woodType.getBurnables()}).map(FeatureBlock::block).toArray(Block[]::new)));
            tags.tag(BlockTags.f_13106_).addTag(woodType.blockTag);
            tags.tag(BlockTags.f_13105_).add((Object[])((Block[])woodType.getBurnables().map(FeatureBlock::block).toArray(Block[]::new)));
            tags.tag(BlockTags.f_215839_).add(((FeatureBlock)ArboricultureBlocks.LOGS.get(woodType)).block());
        }
        tags.tag(BlockTags.f_13030_).add((Object[])ArboricultureBlocks.STAIRS.blockArray());
        tags.tag(BlockTags.f_13096_).add((Object[])ArboricultureBlocks.STAIRS.blockArray());
        tags.tag(BlockTags.f_13039_).add((Object[])ArboricultureBlocks.FENCES.blockArray());
        tags.tag(BlockTags.f_13098_).add((Object[])ArboricultureBlocks.FENCES.blockArray());
        tags.tag(Tags.Blocks.FENCES).add((Object[])ArboricultureBlocks.FENCES.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES).add((Object[])ArboricultureBlocks.FENCE_GATES.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])ArboricultureBlocks.FENCE_GATES.blockArray());
        tags.tag(BlockTags.f_13031_).add((Object[])ArboricultureBlocks.SLABS.blockArray());
        tags.tag(BlockTags.f_13097_).add((Object[])ArboricultureBlocks.SLABS.blockArray());
        tags.tag(BlockTags.f_13103_).add((Object[])ArboricultureBlocks.DOORS.blockArray());
        tags.tag(BlockTags.f_13095_).add((Object[])ArboricultureBlocks.DOORS.blockArray());
        tags.tag(BlockTags.f_13090_).add((Object[])ArboricultureBlocks.PLANKS_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13030_).add((Object[])ArboricultureBlocks.STAIRS_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13096_).add((Object[])ArboricultureBlocks.STAIRS_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13039_).add((Object[])ArboricultureBlocks.FENCES_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCES).add((Object[])ArboricultureBlocks.FENCES_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13098_).add((Object[])ArboricultureBlocks.FENCES_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES).add((Object[])ArboricultureBlocks.FENCE_GATES_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])ArboricultureBlocks.FENCE_GATES_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13031_).add((Object[])ArboricultureBlocks.SLABS_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13097_).add((Object[])ArboricultureBlocks.SLABS_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13090_).add((Object[])ArboricultureBlocks.PLANKS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13106_).add((Object[])ArboricultureBlocks.LOGS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13030_).add((Object[])ArboricultureBlocks.STAIRS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13096_).add((Object[])ArboricultureBlocks.STAIRS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13039_).add((Object[])ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCES).add((Object[])ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13098_).add((Object[])ArboricultureBlocks.FENCES_VANILLA_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES).add((Object[])ArboricultureBlocks.FENCE_GATES_VANILLA_FIREPROOF.blockArray());
        tags.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])ArboricultureBlocks.FENCE_GATES_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13031_).add((Object[])ArboricultureBlocks.SLABS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13097_).add((Object[])ArboricultureBlocks.SLABS_VANILLA_FIREPROOF.blockArray());
        tags.tag(BlockTags.f_13092_).add((Object[])ArboricultureBlocks.BUTTON.blockArray());
        tags.tag(BlockTags.f_13100_).add((Object[])ArboricultureBlocks.BUTTON.blockArray());
        tags.tag(BlockTags.f_13102_).add((Object[])ArboricultureBlocks.TRAPDOORS.blockArray());
        tags.tag(BlockTags.f_13066_).add((Object[])ArboricultureBlocks.SIGN.blockArray());
        tags.tag(BlockTags.f_13067_).add((Object[])ArboricultureBlocks.WALL_SIGN.blockArray());
        tags.tag(BlockTags.f_243838_).add((Object[])ArboricultureBlocks.HANGING_SIGN.blockArray());
        tags.tag(BlockTags.f_244544_).add((Object[])ArboricultureBlocks.WALL_HANGING_SIGN.blockArray());
        tags.tag(BlockTags.f_13104_).add((Object)ArboricultureBlocks.SAPLING_GE.block());
        tags.tag(BlockTags.f_13035_).add((Object)ArboricultureBlocks.LEAVES.block()).add((Object[])ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.blockArray()).add((Object[])ArboricultureBlocks.LEAVES_DEFAULT.blockArray()).add((Object[])ArboricultureBlocks.LEAVES_DECORATIVE.blockArray());
        tags.tag(Tags.Blocks.ORES).addTags(new TagKey[]{ForestryTags.Blocks.ORES_TIN, ForestryTags.Blocks.ORES_APATITE});
        tags.tag(ForestryTags.Blocks.ORES_TIN).add((Object[])new Block[]{CoreBlocks.TIN_ORE.block(), CoreBlocks.DEEPSLATE_TIN_ORE.block()});
        tags.tag(ForestryTags.Blocks.ORES_APATITE).add((Object[])new Block[]{CoreBlocks.APATITE_ORE.block(), CoreBlocks.DEEPSLATE_APATITE_ORE.block()});
        tags.tag(ForestryTags.Blocks.STORAGE_BLOCKS_RAW_TIN).add((Object)CoreBlocks.RAW_TIN_BLOCK.block());
        tags.tag(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{ForestryTags.Blocks.STORAGE_BLOCKS_APATITE, ForestryTags.Blocks.STORAGE_BLOCKS_BRONZE, ForestryTags.Blocks.STORAGE_BLOCKS_TIN});
        tags.tag(ForestryTags.Blocks.STORAGE_BLOCKS_APATITE).add(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.APATITE)).block());
        tags.tag(ForestryTags.Blocks.STORAGE_BLOCKS_TIN).add(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.TIN)).block());
        tags.tag(ForestryTags.Blocks.STORAGE_BLOCKS_BRONZE).add(((FeatureBlock)CoreBlocks.RESOURCE_STORAGE.get(EnumResourceType.BRONZE)).block());
        tags.tag(BlockTags.f_144274_).add((Object)CoreBlocks.HUMUS.block());
        tags.tag(ForestryTags.Blocks.VANILLA_FLOWERS).addTag(BlockTags.f_13041_);
        tags.tag(ForestryTags.Blocks.NETHER_FLOWERS).add((Object[])new Block[]{Blocks.f_50200_, Blocks.f_50691_, Blocks.f_50726_, Blocks.f_50700_, Blocks.f_50725_, Blocks.f_50654_, Blocks.f_50727_, Blocks.f_50693_, Blocks.f_50728_});
        tags.tag(ForestryTags.Blocks.CACTI_FLOWERS).add((Object)Blocks.f_50128_);
        tags.tag(ForestryTags.Blocks.MUSHROOMS_FLOWERS).add((Object[])new Block[]{Blocks.f_50073_, Blocks.f_50245_, Blocks.f_50072_, Blocks.f_50246_});
        tags.tag(ForestryTags.Blocks.END_FLOWERS).add((Object[])new Block[]{Blocks.f_50260_, Blocks.f_50490_, Blocks.f_50491_});
        tags.tag(ForestryTags.Blocks.JUNGLE_FLOWERS).add((Object[])new Block[]{Blocks.f_50191_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50231_});
        tags.tag(ForestryTags.Blocks.SNOW_FLOWERS).addTag(BlockTags.f_13041_);
        tags.tag(ForestryTags.Blocks.WHEAT_FLOWERS).add((Object)Blocks.f_50092_);
        tags.tag(ForestryTags.Blocks.GOURD_FLOWERS).add((Object[])new Block[]{Blocks.f_50190_, Blocks.f_50188_, Blocks.f_50189_, Blocks.f_50187_});
        tags.tag(ForestryTags.Blocks.CAVE_FLOWERS).add((Object[])new Block[]{Blocks.f_152538_, Blocks.f_152539_, Blocks.f_152540_});
        tags.tag(ForestryTags.Blocks.PLANTABLE_FLOWERS).addTag(BlockTags.f_13041_).add((Object[])new Block[]{Blocks.f_50073_, Blocks.f_50072_}).add((Object)Blocks.f_50035_).add((Object[])new Block[]{Blocks.f_50700_, Blocks.f_50691_, Blocks.f_50693_, Blocks.f_50654_});
        tags.tag(ForestryTags.Blocks.PLANTABLE_FLOWERS_GROUND).add((Object[])new Block[]{Blocks.f_50493_, Blocks.f_50440_, Blocks.f_50125_, Blocks.f_49992_, Blocks.f_50062_});
        tags.tag(ForestryTags.Blocks.MODEST_BEE_GROUND).addTag(BlockTags.f_13029_).addTag(BlockTags.f_198156_);
        tags.tag(ForestryTags.Blocks.WINTRY_BEE_GROUND).addTag(BlockTags.f_144274_).addTag(BlockTags.f_144279_);
        tags.tag(ForestryTags.Blocks.LUSH_BEE_CEILING).add((Object)Blocks.f_152544_).add((Object)Blocks.f_152549_);
        tags.tag(ForestryTags.Blocks.CAVE_EXTRA_REPLACEABLES).add((Object)Blocks.f_152588_).add((Object)Blocks.f_152538_).add((Object)Blocks.f_152539_).add((Object)Blocks.f_152548_).add((Object)Blocks.f_152475_);
    }

    private static Collection<Block> union(FeatureBlockGroup<?, ?> ... features) {
        LinkedHashSet<Block> set = new LinkedHashSet<Block>();
        for (FeatureBlockGroup<?, ?> feature : features) {
            set.addAll(feature.getBlocks());
        }
        return set;
    }
}

