/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.circuits.ISocketable;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockStructure
extends BlockForestry {
    protected long previousMessageTick = 0L;

    protected BlockStructure(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (playerIn.m_6144_()) {
            return InteractionResult.PASS;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((BlockGetter)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return InteractionResult.FAIL;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (heldItem.m_41619_()) {
            if (controller != null) {
                String validationError;
                if (!controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
                    long tick = worldIn.m_46467_();
                    if (tick > this.previousMessageTick + 20L) {
                        playerIn.m_213846_((Component)Component.m_237113_((String)validationError));
                        this.previousMessageTick = tick;
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"for.multiblock.error.notConnected"));
                return InteractionResult.SUCCESS;
            }
        }
        if (controller == null || !controller.isAssembled()) {
            return InteractionResult.PASS;
        }
        if (!worldIn.f_46443_) {
            part.openGui((ServerPlayer)playerIn, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (placer instanceof Player) {
            TileUtil.actOnTile((LevelReader)world, pos, MultiblockTileEntityForestry.class, tile -> {
                Player player = (Player)placer;
                GameProfile gameProfile = player.m_36316_();
                tile.setOwner(gameProfile);
            });
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        TileUtil.actOnTile((LevelReader)world, pos, IMultiblockComponent.class, tile -> {
            if (MultiblockUtil.getNeighboringParts(world, tile).isEmpty()) {
                if (tile instanceof Container) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tile));
                }
                if (tile instanceof ISocketable) {
                    InventoryUtil.dropSockets((ISocketable)((Object)tile), world, pos);
                }
            }
        });
        super.m_6240_(world, player, pos, state, te, stack);
    }
}

