/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.farming.HorizontalDirection;
import forestry.core.blocks.BlockForestry;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IBlockTypeCustom;
import forestry.core.blocks.IMachineProperties;
import forestry.core.circuits.ISocketable;
import forestry.core.tiles.TileBase;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;

public class BlockBase<P extends Enum<P>>
extends BlockForestry
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.m_61590_((String)"facing", Direction.class, HorizontalDirection.VALUES);
    public final P blockType;

    private static BlockBehaviour.Properties createProperties(IBlockType type, BlockBehaviour.Properties properties) {
        if (type instanceof IBlockTypeCustom) {
            properties = properties.m_60955_();
        }
        return properties.m_60978_(2.0f);
    }

    public BlockBase(P blockType, BlockBehaviour.Properties properties) {
        super(BlockBase.createProperties((IBlockType)blockType, properties));
        if (((BlockState)this.m_49965_().m_61090_()).m_61138_(FACING)) {
            this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH));
        }
        this.blockType = blockType;
        ((IBlockType)blockType).getMachineProperties().setBlock(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 0.2f;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.getDefinition().createTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actualType) {
        if (actualType == ((IBlockType)this.blockType).getMachineProperties().getTeType()) {
            return level.f_46443_ ? ((IBlockType)this.blockType).getMachineProperties().getClientTicker() : ((IBlockType)this.blockType).getMachineProperties().getServerTicker();
        }
        return null;
    }

    private IMachineProperties<?> getDefinition() {
        return ((IBlockType)this.blockType).getMachineProperties();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        IMachineProperties<?> definition = this.getDefinition();
        return definition.getShape(state, reader, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        TileBase tile = TileUtil.getTile((BlockGetter)worldIn, pos, TileBase.class);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (TileUtil.isUsableByPlayer(playerIn, tile)) {
            if (!playerIn.m_6144_() && FluidUtil.interactWithFluidHandler((Player)playerIn, (InteractionHand)hand, (Level)worldIn, (BlockPos)pos, (Direction)hit.m_82434_())) {
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (!worldIn.f_46443_) {
                ServerPlayer sPlayer = (ServerPlayer)playerIn;
                tile.openGui(sPlayer, hand, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = TileUtil.getTile((BlockGetter)level, pos);
            if (tile instanceof Container) {
                Container inventory = (Container)tile;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)inventory);
            }
            if (tile instanceof TileForestry) {
                TileForestry forestry = (TileForestry)tile;
                forestry.onDropContents((ServerLevel)level);
            }
            if (tile instanceof ISocketable) {
                ISocketable socketable = (ISocketable)tile;
                InventoryUtil.dropSockets(socketable, level, pos);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction facing = (Direction)state.m_61143_(FACING);
        return (BlockState)state.m_61124_(FACING, (Comparable)rot.m_55954_(facing));
    }
}

