/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.FeatureArboriculture;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.utils.SpeciesUtil;
import forestry.core.worldgen.FeatureBase;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileSapling
extends TileTreeContainer
implements IOwnedTile {
    public static final ModelProperty<ITreeSpecies> TREE_SPECIES = new ModelProperty();
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private int timesTicked = 0;

    public TileSapling(BlockPos pos, BlockState state) {
        super(ArboricultureTiles.SAPLING.tileType(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.timesTicked = nbt.m_128451_("TT");
        this.ownerHandler.read(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("TT", this.timesTicked);
        this.ownerHandler.write(nbt);
    }

    @Override
    public void onBlockTick(Level worldIn, BlockPos pos, BlockState state, RandomSource rand) {
        ++this.timesTicked;
        this.tryGrow(rand, false);
    }

    private static int getRequiredMaturity(Level world, ITree tree) {
        return tree.getRequiredMaturity();
    }

    public boolean canAcceptBoneMeal(RandomSource rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        int maturity = TileSapling.getRequiredMaturity(this.f_58857_, tree);
        if (this.timesTicked < maturity) {
            return true;
        }
        Feature<NoneFeatureConfiguration> generator = tree.getTreeGenerator((WorldGenLevel)((ServerLevel)this.f_58857_), this.m_58899_(), true);
        if (generator instanceof FeatureArboriculture) {
            FeatureArboriculture arboricultureGenerator = (FeatureArboriculture)generator;
            arboricultureGenerator.preGenerate(this.getTree().getGenome(), (LevelAccessor)this.f_58857_, rand, this.m_58899_());
            return arboricultureGenerator.getValidGrowthPos((LevelAccessor)this.f_58857_, this.m_58899_()) != null;
        }
        return true;
    }

    public void tryGrow(RandomSource random, boolean boneMealed) {
        boolean generated;
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        int maturity = TileSapling.getRequiredMaturity(this.f_58857_, tree);
        if (this.timesTicked < maturity) {
            if (boneMealed) {
                this.timesTicked = maturity;
            }
            return;
        }
        Feature<NoneFeatureConfiguration> generator = tree.getTreeGenerator((WorldGenLevel)((ServerLevel)this.f_58857_), this.m_58899_(), boneMealed);
        if (generator instanceof FeatureBase) {
            FeatureBase base = (FeatureBase)generator;
            generated = base.place(tree.getGenome(), (LevelAccessor)this.f_58857_, random, this.m_58899_(), false);
        } else {
            ServerLevel level = (ServerLevel)this.f_58857_;
            generated = generator.m_142674_(new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)level, level.m_7726_().m_8481_(), random, this.m_58899_(), (FeatureConfiguration)FeatureConfiguration.f_67737_));
        }
        if (generated) {
            IArboristTracker breedingTracker = ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getBreedingTracker((LevelAccessor)this.f_58857_, this.getOwnerHandler().getOwner());
            breedingTracker.registerBirth(tree.getSpecies());
        }
    }

    @Nonnull
    public ModelData getModelData() {
        ITree tree = this.getTree();
        if (tree == null) {
            return ModelData.EMPTY;
        }
        return ModelData.builder().with(TREE_SPECIES, (Object)tree.getSpecies()).build();
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }
}

