/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.client.IForestryClientApi;
import forestry.api.client.arboriculture.ILeafSprite;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.models.ModelLeaves;
import forestry.core.models.ModelBlockCached;
import forestry.core.models.baker.ModelBaker;
import forestry.core.utils.ResourceUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class ModelDefaultLeaves
extends ModelBlockCached<BlockDefaultLeaves, Key> {
    public ModelDefaultLeaves() {
        super(BlockDefaultLeaves.class);
    }

    @Override
    protected Key getInventoryKey(ItemStack stack) {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        Preconditions.checkArgument((boolean)(block instanceof BlockDefaultLeaves), (Object)"ItemStack must be for default leaves.");
        BlockDefaultLeaves bBlock = (BlockDefaultLeaves)block;
        return new Key(bBlock.getSpeciesId(), Minecraft.m_91405_());
    }

    @Override
    protected Key getWorldKey(BlockState state, ModelData extraData) {
        Block block = state.m_60734_();
        if (block instanceof BlockDefaultLeaves) {
            BlockDefaultLeaves block2 = (BlockDefaultLeaves)block;
            ResourceLocation treeDefinition = block2.getSpeciesId();
            return new Key(treeDefinition, Minecraft.m_91405_());
        }
        throw new IllegalArgumentException("state must be for default leaves.");
    }

    @Override
    protected void bakeBlock(BlockDefaultLeaves block, ModelData extraData, Key key, ModelBaker baker, boolean inventory) {
        ResourceLocation speciesId = key.speciesId;
        ITreeSpecies species = SpeciesUtil.getTreeSpecies(speciesId);
        ILeafSprite leafSpriteProvider = IForestryClientApi.INSTANCE.getTreeManager().getLeafSprite(species);
        ResourceLocation leafSpriteLocation = leafSpriteProvider.get(false, key.fancy);
        TextureAtlasSprite leafSprite = ResourceUtil.getBlockSprite(leafSpriteLocation);
        baker.addBlockModel(leafSprite, 0);
        baker.setParticleSprite(leafSprite);
    }

    @Override
    protected BakedModel bakeModel(BlockState state, Key key, BlockDefaultLeaves block, ModelData extraData) {
        ModelBaker baker = new ModelBaker();
        this.bakeBlock(block, extraData, key, baker, false);
        this.blockModel = baker.bake(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    @Override
    public ItemTransforms m_7442_() {
        return ModelLeaves.TRANSFORMS;
    }

    public static final class Key {
        public final ResourceLocation speciesId;
        public final boolean fancy;
        private final int hashCode;

        public Key(ResourceLocation speciesId, boolean fancy) {
            this.speciesId = speciesId;
            this.fancy = fancy;
            this.hashCode = Objects.hash(speciesId, fancy);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            return otherKey.speciesId == this.speciesId && otherKey.fancy == this.fancy;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

