/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.client;

import forestry.api.client.IClientModuleHandler;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.client.ForestryBoatRenderer;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.arboriculture.features.ArboricultureEntities;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.models.ModelDecorativeLeaves;
import forestry.arboriculture.models.ModelDefaultLeaves;
import forestry.arboriculture.models.ModelDefaultLeavesFruit;
import forestry.arboriculture.models.ModelLeaves;
import forestry.arboriculture.models.SaplingModelLoader;
import forestry.core.models.ClientManager;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ArboricultureClientHandler
implements IClientModuleHandler {
    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(ArboricultureClientHandler::registerModelLoaders);
        modBus.addListener(ArboricultureClientHandler::onClientSetup);
        modBus.addListener(ArboricultureClientHandler::registerEntityRenderers);
        modBus.addListener(ArboricultureClientHandler::registerModelLayers);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientManager clientManager = ClientManager.INSTANCE;
            clientManager.registerModel((BakedModel)new ModelLeaves(), ArboricultureBlocks.LEAVES);
            clientManager.registerModel(new ModelDecorativeLeaves<BlockDecorativeLeaves>(BlockDecorativeLeaves.class), ArboricultureBlocks.LEAVES_DECORATIVE);
            clientManager.registerModel((BakedModel)new ModelDefaultLeaves(), ArboricultureBlocks.LEAVES_DEFAULT);
            clientManager.registerModel((BakedModel)new ModelDefaultLeavesFruit(), ArboricultureBlocks.LEAVES_DEFAULT_FRUIT);
            ArboricultureBlocks.LEAVES_DEFAULT.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ItemBlockRenderTypes.setRenderLayer((Block)ArboricultureBlocks.LEAVES.block(), (RenderType)RenderType.m_110457_());
            ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ArboricultureBlocks.LEAVES_DECORATIVE.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            ItemBlockRenderTypes.setRenderLayer((Block)ArboricultureBlocks.SAPLING_GE.block(), (RenderType)RenderType.m_110463_());
            ArboricultureBlocks.DOORS.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
            ArboricultureBlocks.PODS.getBlocks().forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
            for (ForestryWoodType type : ForestryWoodType.VALUES) {
                Sheets.addWoodType((WoodType)type.getWoodType());
            }
        });
    }

    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("sapling_ge", (IGeometryLoader)new SaplingModelLoader());
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ArboricultureEntities.BOAT.entityType(), ctx -> new ForestryBoatRenderer(ctx, false));
        event.registerEntityRenderer(ArboricultureEntities.CHEST_BOAT.entityType(), ctx -> new ForestryBoatRenderer(ctx, true));
        event.registerBlockEntityRenderer(ArboricultureTiles.SIGN.tileType(), SignRenderer::new);
        event.registerBlockEntityRenderer(ArboricultureTiles.HANGING_SIGN.tileType(), HangingSignRenderer::new);
    }

    private static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (ForestryWoodType type : ForestryWoodType.VALUES) {
            event.registerLayerDefinition(ForestryBoatRenderer.createBoatModelLocation(type, false), BoatModel::m_246613_);
            event.registerLayerDefinition(ForestryBoatRenderer.createBoatModelLocation(type, true), ChestBoatModel::m_247175_);
        }
    }
}

