/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.client.IForestryClientApi;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.core.blocks.IColoredBlock;
import forestry.core.utils.BlockUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class BlockDecorativeLeaves
extends Block
implements IColoredBlock,
IForgeShearable {
    private final ForestryLeafType type;

    public BlockDecorativeLeaves(ForestryLeafType type) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_56740_).m_60955_().m_60922_(BlockUtil.IS_PARROT_OR_OCELOT).m_60960_(BlockUtil.ALWAYS).m_60924_(BlockUtil.NEVER).m_60971_(BlockUtil.NEVER));
        this.type = type;
    }

    public ResourceLocation getSpeciesId() {
        return this.type.getSpeciesId();
    }

    public ForestryLeafType getType() {
        return this.type;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (this.type == ForestryLeafType.WILLOW) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        Vec3 motion = entityIn.m_20184_();
        entityIn.m_20256_(motion.m_82542_(0.4, 1.0, 0.4));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        ITree individual = this.type.getIndividual();
        if (tintIndex == 2) {
            IFruit fruitProvider = individual.getGenome().getActiveValue(TreeChromosomes.FRUIT);
            return fruitProvider.getDecorativeColor();
        }
        return IForestryClientApi.INSTANCE.getTreeManager().getTint(individual.getSpecies()).get(level, pos);
    }
}

