/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DummyFruit
implements IFruit {
    private final boolean dominant;

    public DummyFruit(boolean dominant) {
        this.dominant = dominant;
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    @Override
    public List<ItemStack> getFruits(IGenome genome, Level level, int ripeningTime) {
        return List.of();
    }

    @Override
    public boolean requiresFruitBlocks() {
        return false;
    }

    @Override
    public boolean trySpawnFruitBlock(IGenome genome, LevelAccessor world, RandomSource rand, BlockPos pos) {
        return false;
    }

    @Override
    public int getColour(IGenome genome, BlockGetter world, BlockPos pos, int ripeningTime) {
        return 0xFFFFFF;
    }

    @Override
    public int getDecorativeColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean isFruitLeaf() {
        return false;
    }

    @Override
    public float getFruitChance(IGenome genome, LevelAccessor level) {
        ITreeSpeciesType treeRoot = (ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get();
        if (treeRoot == null) {
            return 0.0f;
        }
        return genome.getActiveValue(TreeChromosomes.YIELD) * 2.5f;
    }

    @Override
    public int getRipeningPeriod() {
        return 0;
    }

    @Override
    public List<IProduct> getProducts() {
        return List.of();
    }

    @Override
    public List<IProduct> getSpecialty() {
        return List.of();
    }

    @Override
    @Nullable
    public ResourceLocation getSprite(IGenome genome, BlockGetter world, BlockPos pos, int ripeningTime) {
        return this.getDecorativeSprite();
    }
}

