/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.tiles.IActivatable;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.ForestryEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IActivatable,
IAlvearyComponent.Climatiser<MultiblockLogicAlveary> {
    private static final int TICKS_PER_CYCLE = 1;
    private static final int FE_PER_OPERATION = 50;
    private final ForestryEnergyStorage energyStorage;
    private final LazyOptional<ForestryEnergyStorage> energyCap;
    private final byte temperatureSteps;
    private int workingTime = 0;

    protected TileAlvearyClimatiser(BlockAlvearyType alvearyType, BlockPos pos, BlockState state, byte temperatureSteps) {
        super(alvearyType, pos, state);
        this.temperatureSteps = temperatureSteps;
        this.energyStorage = new ForestryEnergyStorage(1000, 2000, EnergyTransferMode.RECEIVE);
        this.energyCap = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    public void changeClimate(int tick, IClimateControlled climateControlled) {
        if (this.workingTime < 20 && EnergyHelper.consumeEnergyToDoWork(this.energyStorage, 1, 50)) {
            this.workingTime += 5;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            climateControlled.addTemperatureChange(this.temperatureSteps);
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.energyStorage.read(compoundNBT);
        this.workingTime = compoundNBT.m_128451_("Heating");
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.energyStorage.write(compoundNBT);
        compoundNBT.m_128405_("Heating", this.workingTime);
    }

    @Override
    protected void encodeDescriptionPacket(CompoundTag packetData) {
        super.encodeDescriptionPacket(packetData);
    }

    @Override
    protected void decodeDescriptionPacket(CompoundTag packetData) {
        super.decodeDescriptionPacket(packetData);
    }

    @Override
    public boolean isActive() {
        return this.m_58900_().m_61143_(BlockAlveary.STATE) == BlockAlveary.State.ON;
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive() != active) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(BlockAlveary.STATE, (Comparable)((Object)(active ? BlockAlveary.State.ON : BlockAlveary.State.OFF))));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(capability, facing);
    }
}

