/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.hives.IHiveTile;
import forestry.core.items.ItemForestry;
import forestry.core.render.ParticleRender;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class ItemSmoker
extends ItemForestry {
    public ItemSmoker() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (level.f_46443_ && isSelected && level.f_46441_.m_188503_(40) == 0) {
            ItemSmoker.addSmoke(level, entity, 1);
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        ItemSmoker.addSmoke(level, (Entity)entity, count % 5 + 1);
    }

    private static HumanoidArm getHandSide(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entity;
            InteractionHand activeHand = LivingEntity2.m_7655_();
            HumanoidArm handSide = LivingEntity2.m_5737_();
            if (activeHand == InteractionHand.OFF_HAND) {
                handSide = handSide.m_20828_();
            }
            return handSide;
        }
        return HumanoidArm.RIGHT;
    }

    private static void addSmoke(Level level, Entity entity, int distance) {
        if (distance <= 0) {
            return;
        }
        Vec3 look = entity.m_20154_();
        HumanoidArm handSide = ItemSmoker.getHandSide(entity);
        Vec3 handOffset = handSide == HumanoidArm.RIGHT ? look.m_82537_(new Vec3(0.0, 1.0, 0.0)) : look.m_82537_(new Vec3(0.0, -1.0, 0.0));
        Vec3 lookDistance = new Vec3(look.f_82479_ * (double)distance, look.f_82480_ * (double)distance, look.f_82481_ * (double)distance);
        Vec3 scaledOffset = handOffset.m_82490_(1.0 / (double)distance);
        Vec3 smokePos = lookDistance.m_82549_(entity.m_20182_()).m_82549_(scaledOffset);
        if (level.f_46443_) {
            ParticleRender.addEntitySmokeFX(level, smokePos.f_82479_, smokePos.f_82480_ + 1.0, smokePos.f_82481_);
        }
        BlockPos blockPos = BlockPos.m_274561_((double)smokePos.f_82479_, (double)(smokePos.f_82480_ + 1.0), (double)smokePos.f_82481_);
        TileUtil.actOnTile((LevelReader)level, blockPos, IHiveTile.class, IHiveTile::calmBees);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        ItemStack itemStack = player.m_21120_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileUtil.actOnTile((LevelReader)context.m_43725_(), context.m_8083_(), IHiveTile.class, IHiveTile::calmBees);
        return super.onItemUseFirst(stack, context);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }
}

