/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.IBeeEffect;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.effects.DummyBeeEffect;
import forestry.core.genetics.EffectData;
import forestry.core.utils.VecUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public abstract class ThrottledBeeEffect
extends DummyBeeEffect
implements IBeeEffect {
    private final boolean isCombinable;
    private final int throttle;
    private final boolean requiresWorkingQueen;

    protected ThrottledBeeEffect(boolean dominant, int throttle, boolean requiresWorking, boolean isCombinable) {
        super(dominant);
        this.throttle = throttle;
        this.isCombinable = isCombinable;
        this.requiresWorkingQueen = requiresWorking;
    }

    public static AABB getBounding(IBeeHousing housing, IGenome genome) {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
        Vec3i territory = Bee.getAdjustedTerritory(genome, beeModifier);
        BlockPos offset = VecUtil.scale(territory, -0.5f);
        BlockPos min = housing.getCoordinates().m_121955_((Vec3i)offset);
        BlockPos max = min.m_121955_(territory);
        return new AABB((double)min.m_123341_(), (double)min.m_123342_(), (double)min.m_123343_(), (double)max.m_123341_(), (double)max.m_123342_(), (double)max.m_123343_());
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IGenome genome, IBeeHousing housing, Class<T> entityClass) {
        AABB boundingBox = ThrottledBeeEffect.getBounding(housing, genome);
        return housing.getWorldObj().m_45976_(entityClass, boundingBox);
    }

    @Override
    public boolean isCombinable() {
        return this.isCombinable;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    @Override
    public final IEffectData doEffect(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isThrottled(storedData, housing)) {
            return storedData;
        }
        return this.doEffectThrottled(genome, storedData, housing);
    }

    private boolean isThrottled(IEffectData storedData, IBeeHousing housing) {
        if (this.requiresWorkingQueen && housing.getErrorLogic().hasErrors()) {
            return true;
        }
        int time = storedData.getInteger(0);
        storedData.setInteger(0, ++time);
        if (time < this.throttle) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    abstract IEffectData doEffectThrottled(IGenome var1, IEffectData var2, IBeeHousing var3);
}

