/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeEffect;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.genetics.Bee;
import forestry.core.tiles.TileUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public abstract class NonStackingBeeEffect
implements IBeeEffect {
    private final HashMap<ResourceKey<Level>, HashSet<BlockPos>> trackedOwners;
    private final boolean dominant;

    public NonStackingBeeEffect(boolean dominant) {
        this.dominant = dominant;
        this.trackedOwners = new HashMap();
        MinecraftForge.EVENT_BUS.addListener(this::performGlobalEffect);
    }

    @Override
    public IEffectData doEffect(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        if ((housing.getWorldObj().m_46467_() & 0x40L) == 0L) {
            this.trackedOwners.computeIfAbsent((ResourceKey<Level>)housing.getWorldObj().m_46472_(), key -> new HashSet()).add(housing.getCoordinates());
        }
        return IBeeEffect.super.doEffect(genome, storedData, housing);
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    private void performGlobalEffect(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (level.f_46443_ || level.m_46467_() % 550L != 0L) {
            return;
        }
        HashSet owners = this.trackedOwners.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new HashSet());
        HashSet<BlockPos> affectedHives = new HashSet<BlockPos>();
        Iterator iterator = owners.iterator();
        while (iterator.hasNext()) {
            IIndividual queen;
            IGenome genome;
            IIndividualHandlerItem handler;
            BlockPos pos = (BlockPos)iterator.next();
            IBeeHousing housing = TileUtil.getTile((BlockGetter)level, pos, IBeeHousing.class);
            if (!(housing == null || housing.getErrorLogic().hasErrors() || (handler = IIndividualHandlerItem.get(housing.getBeeInventory().getQueen())) == null || handler.getStage() != BeeLifeStage.QUEEN || (genome = (queen = handler.getIndividual()).getGenome()).getActiveValue(BeeChromosomes.EFFECT) != this && genome.getInactiveValue(BeeChromosomes.EFFECT) != this)) {
                IBeeModifier modifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
                Vec3i territory = Bee.getAdjustedTerritory(genome, modifier);
                this.applyEffectToNearbyTiles(affectedHives, level, pos, territory);
                continue;
            }
            iterator.remove();
        }
    }

    private void applyEffectToNearbyTiles(HashSet<BlockPos> affectedHives, Level level, BlockPos pos, Vec3i territory) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int xWidth = territory.m_123341_();
        int zWidth = territory.m_123343_();
        int xChunksPositive = (x % 16 + xWidth) / 16;
        int zChunksPositive = (z % 16 + zWidth) / 16;
        int xChunksNegative = (x % 16 - xWidth) / 16;
        int zChunksNegative = (z % 16 - zWidth) / 16;
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        for (int i = chunkX - xChunksPositive; i <= chunkX + xChunksNegative; ++i) {
            for (int j = chunkZ - zChunksPositive; j <= chunkZ + zChunksNegative; ++j) {
                level.m_6325_((int)i, (int)j).f_187610_.forEach((targetPos, blockEntity) -> {
                    if (blockEntity instanceof IBeeHousing) {
                        IBeeHousing housing = (IBeeHousing)blockEntity;
                        int distX = Math.abs(pos.m_123341_() - targetPos.m_123341_());
                        int distY = Math.abs(pos.m_123342_() - targetPos.m_123342_());
                        int distZ = Math.abs(pos.m_123343_() - targetPos.m_123343_());
                        if (distX > territory.m_123341_() || distY > territory.m_123342_() || distZ > territory.m_123343_() || pos.equals(targetPos)) {
                            return;
                        }
                        if (affectedHives.add((BlockPos)targetPos)) {
                            this.doEffectForHive(level, housing);
                        }
                    }
                });
            }
        }
    }

    protected abstract void doEffectForHive(Level var1, IBeeHousing var2);
}

