/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.core.utils.VecUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GlacialBeeEffect
extends ThrottledBeeEffect {
    public GlacialBeeEffect() {
        super(false, 200, true, false);
    }

    @Override
    public IEffectData doEffectThrottled(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        Level level = housing.getWorldObj();
        if (housing.temperature().isWarmerOrEqual(TemperatureType.WARM)) {
            return storedData;
        }
        Vec3i area = genome.getActiveValue(BeeChromosomes.TERRITORY);
        BlockPos offset = VecUtil.scale(area, -0.5f);
        BlockPos housingCoords = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            Block block;
            BlockPos randomPos = VecUtil.getRandomPositionInArea(level.f_46441_, area);
            BlockPos posBlock = VecUtil.sum(new Vec3i[]{randomPos, housingCoords, offset});
            if (!level.m_46805_(posBlock) || (block = level.m_8055_(posBlock).m_60734_()) != Blocks.f_49990_ || !level.m_46859_(new BlockPos(posBlock.m_123341_(), posBlock.m_123342_() + 1, posBlock.m_123343_()))) continue;
            level.m_46597_(posBlock, Blocks.f_50126_.m_49966_());
        }
        return storedData;
    }
}

