/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.compat;

import forestry.api.ForestryConstants;
import forestry.api.IForestryApi;
import forestry.api.core.IProductProducer;
import forestry.api.core.ISpecialtyProducer;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.modules.ForestryModuleIds;
import forestry.apiculture.compat.MutationRecipe;
import forestry.apiculture.compat.MutationsRecipeCategory;
import forestry.apiculture.compat.ProductRecipe;
import forestry.apiculture.compat.ProductsRecipeCategory;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.items.ItemCreativeHiveFrame;
import forestry.core.utils.JeiUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

@JeiPlugin
public class ApicultureJeiPlugin
implements IModPlugin {
    static final ResourceLocation BACKGROUND = ForestryConstants.forestry("textures/gui/jei/recipes.png");
    static final List<ProductsRecipeCategory> productsCategories = new ArrayList<ProductsRecipeCategory>();
    static final List<MutationsRecipeCategory> mutationsCategories = new ArrayList<MutationsRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return ForestryModuleIds.APICULTURE;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        IDrawableStatic productsBackground = helper.createDrawable(BACKGROUND, 0, 91, 162, 61);
        IDrawableStatic mutationsBackground = helper.createDrawable(BACKGROUND, 0, 30, 162, 61);
        for (ISpeciesType<?, ?> type : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            Object category;
            IDrawable icon = helper.createDrawableItemStack(type.createDefaultStack());
            if (type.getDefaultSpecies() instanceof IProductProducer) {
                category = new ProductsRecipeCategory(type, (IDrawable)productsBackground, icon);
                productsCategories.add((ProductsRecipeCategory)category);
                registration.addRecipeCategories(new IRecipeCategory[]{category});
            }
            category = new MutationsRecipeCategory(type, (IDrawable)mutationsBackground, icon);
            mutationsCategories.add((MutationsRecipeCategory)category);
            registration.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        JeiUtil.registerItemSubtypes(registry, BeeChromosomes.SPECIES, (ISpeciesType)SpeciesUtil.BEE_TYPE.get());
        registry.registerSubtypeInterpreter((Item)ApicultureItems.FRAME_CREATIVE.item(), (stack, context) -> String.valueOf(ItemCreativeHiveFrame.hasForceMutations(stack)));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        JeiUtil.addDescription(registry, "frames", ApicultureItems.FRAME_IMPREGNATED, ApicultureItems.FRAME_PROVEN, ApicultureItems.FRAME_UNTREATED);
        JeiUtil.addDescription(registry, "apiarist.suit", ApicultureItems.APIARIST_BOOTS, ApicultureItems.APIARIST_CHEST, ApicultureItems.APIARIST_HELMET, ApicultureItems.APIARIST_LEGS);
        JeiUtil.addDescription(registry, ApicultureItems.SCOOP);
        for (MutationsRecipeCategory mutationsRecipeCategory : mutationsCategories) {
            registry.addRecipes(mutationsRecipeCategory.getRecipeType(), mutationsRecipeCategory.speciesType.getMutations().getAllMutations().stream().map(MutationRecipe::new).toList());
        }
        for (ProductsRecipeCategory productsRecipeCategory : productsCategories) {
            registry.addRecipes(productsRecipeCategory.getRecipeType(), productsRecipeCategory.speciesType.getAllSpecies().stream().filter(species -> {
                ISpecialtyProducer specialtyProducer;
                IProductProducer producer;
                return species instanceof IProductProducer && !(producer = (IProductProducer)((Object)species)).getProducts().isEmpty() || species instanceof ISpecialtyProducer && !(specialtyProducer = (ISpecialtyProducer)((Object)species)).getSpecialties().isEmpty();
            }).map(species -> new ProductRecipe((ISpecies<?>)species.cast())).toList());
        }
        mutationsCategories.clear();
        productsCategories.clear();
    }
}

