/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MultiblockTileEntityBase<T extends IMultiblockLogic>
extends BlockEntity
implements IMultiblockComponent {
    private final T multiblockLogic;

    public MultiblockTileEntityBase(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state, T multiblockLogic) {
        super(tileEntityType, pos, state);
        this.multiblockLogic = multiblockLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.m_58899_();
    }

    public T getMultiblockLogic() {
        return this.multiblockLogic;
    }

    @Override
    public abstract void onMachineAssembled(IMultiblockController var1, BlockPos var2, BlockPos var3);

    @Override
    public abstract void onMachineBroken();

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.multiblockLogic.readFromNBT(data);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.multiblockLogic.write(data);
    }

    public void m_7651_() {
        super.m_7651_();
        this.multiblockLogic.invalidate(this.f_58857_, this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.multiblockLogic.onChunkUnload(this.f_58857_, this);
    }

    public void onLoad() {
        super.onLoad();
        this.multiblockLogic.validate(this.f_58857_, this);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.multiblockLogic.encodeDescriptionPacket(updateTag);
        this.encodeDescriptionPacket(updateTag);
        return updateTag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void onDataPacket(Connection network, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(network, packet);
        CompoundTag nbtData = packet.m_131708_();
        if (nbtData != null) {
            this.multiblockLogic.decodeDescriptionPacket(nbtData);
            this.decodeDescriptionPacket(nbtData);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.multiblockLogic.decodeDescriptionPacket(tag);
        this.decodeDescriptionPacket(tag);
    }

    protected void encodeDescriptionPacket(CompoundTag packetData) {
    }

    protected void decodeDescriptionPacket(CompoundTag packetData) {
    }
}

