/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IBooleanChromosome;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IFloatChromosome;
import forestry.api.genetics.alleles.IIntegerChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.IValueChromosome;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.network.chat.MutableComponent;

public interface IGenome {
    public ImmutableList<AllelePair<?>> getAllelePairs();

    public <A extends IAllele> AllelePair<A> getAllelePair(IChromosome<A> var1);

    public boolean isDefaultGenome();

    public IKaryotype getKaryotype();

    public ImmutableMap<IChromosome<?>, AllelePair<?>> getChromosomes();

    default public IGenome copyWith(Map<IChromosome<?>, IAllele> alleles) {
        IdentityHashMap pairMap = new IdentityHashMap(alleles.size());
        for (Map.Entry<IChromosome<?>, IAllele> entry : alleles.entrySet()) {
            IChromosome<?> chromosome = entry.getKey();
            IAllele allele = entry.getValue();
            pairMap.put(chromosome, new AllelePair<IAllele>(allele, allele));
        }
        return this.copyWithPairs(pairMap);
    }

    public IGenome copyWithPairs(Map<IChromosome<?>, AllelePair<?>> var1);

    public boolean isSameAlleles(IGenome var1);

    default public <A extends IAllele> A getActiveAllele(IChromosome<A> chromosome) {
        return this.getAllelePair(chromosome).active();
    }

    default public float getActiveValue(IFloatChromosome chromosome) {
        return this.getActiveAllele(chromosome).value();
    }

    default public boolean getActiveValue(IBooleanChromosome chromosome) {
        return this.getActiveAllele(chromosome).value();
    }

    default public int getActiveValue(IIntegerChromosome chromosome) {
        return this.getActiveAllele(chromosome).value();
    }

    default public <V> V getActiveValue(IValueChromosome<V> chromosome) {
        return ((IValueAllele)this.getActiveAllele(chromosome)).value();
    }

    default public <A extends IAllele> A getInactiveAllele(IChromosome<A> chromosome) {
        return this.getAllelePair(chromosome).inactive();
    }

    default public float getInactiveValue(IFloatChromosome chromosome) {
        return this.getInactiveAllele(chromosome).value();
    }

    default public boolean getInactiveValue(IBooleanChromosome chromosome) {
        return this.getInactiveAllele(chromosome).value();
    }

    default public int getInactiveValue(IIntegerChromosome chromosome) {
        return this.getInactiveAllele(chromosome).value();
    }

    default public <V> V getInactiveValue(IValueChromosome<V> chromosome) {
        return ((IValueAllele)this.getInactiveAllele(chromosome)).value();
    }

    default public MutableComponent getActiveName(IFloatChromosome chromosome) {
        return chromosome.getDisplayName(this.getActiveAllele(chromosome));
    }

    default public MutableComponent getActiveName(IBooleanChromosome chromosome) {
        return chromosome.getDisplayName(this.getActiveAllele(chromosome));
    }

    default public MutableComponent getActiveName(IIntegerChromosome chromosome) {
        return chromosome.getDisplayName(this.getActiveAllele(chromosome));
    }

    default public <V> MutableComponent getActiveName(IValueChromosome<V> chromosome) {
        return chromosome.getDisplayName((IValueAllele)this.getActiveAllele(chromosome));
    }

    default public MutableComponent getInactiveName(IFloatChromosome chromosome) {
        return chromosome.getDisplayName(this.getInactiveAllele(chromosome));
    }

    default public MutableComponent getInactiveName(IBooleanChromosome chromosome) {
        return chromosome.getDisplayName(this.getInactiveAllele(chromosome));
    }

    default public MutableComponent getInactiveName(IIntegerChromosome chromosome) {
        return chromosome.getDisplayName(this.getInactiveAllele(chromosome));
    }

    default public <V> MutableComponent getInactiveName(IValueChromosome<V> chromosome) {
        return chromosome.getDisplayName((IValueAllele)this.getInactiveAllele(chromosome));
    }

    default public <S extends ISpecies<?>> S getActiveSpecies() {
        return (S)this.getActiveValue(this.getKaryotype().getSpeciesChromosome());
    }

    default public <S extends ISpecies<?>> S getInactiveSpecies() {
        return (S)this.getInactiveValue(this.getKaryotype().getSpeciesChromosome());
    }
}

