/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import forestry.api.IForestryApi;
import forestry.api.core.IError;
import forestry.api.core.IErrorManager;
import forestry.api.core.IErrorSource;
import java.util.Set;

public interface IErrorLogic
extends IErrorSource {
    public boolean setCondition(boolean var1, IError var2);

    public boolean contains(IError var1);

    public boolean hasErrors();

    public void clearErrors();

    default public short[] toArray() {
        IErrorManager manager = IForestryApi.INSTANCE.getErrorManager();
        Set<IError> errors = this.getErrors();
        short[] statesArray = new short[errors.size()];
        int i = 0;
        for (IError error : errors) {
            statesArray[i] = manager.getNumericId(error);
            ++i;
        }
        return statesArray;
    }

    default public void fromArray(short[] errorArray) {
        this.clearErrors();
        IErrorManager manager = IForestryApi.INSTANCE.getErrorManager();
        for (short errorId : errorArray) {
            IError error = manager.getError(errorId);
            if (error == null) continue;
            this.setCondition(true, error);
        }
    }
}

