/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AutoSprintUtil {
    private static final String NBT = "isautorunning";

    public static Vec3 vector(Player p, float speed) {
        p.f_20902_ = speed;
        Vec3 vec = new Vec3((double)p.f_20900_, (double)p.f_20901_, (double)p.f_20902_);
        return vec;
    }

    public static void moveAlongVector(Boat p, Vec3 vec) {
        Level world = p.m_9236_();
        BlockPos blockpos = BlockPos.m_274561_((double)p.m_20185_(), (double)(p.m_20191_().f_82289_ - 1.0), (double)p.m_20189_());
        BlockState blockState = world.m_8055_(blockpos);
        float f5 = blockState.getFriction((LevelReader)world, blockpos, (Entity)p);
        p.m_19920_(AutoSprintUtil.getRelevantMoveFactorBoat(p, f5), vec);
    }

    public static void moveAlongVector(LivingEntity p, Vec3 vec) {
        Level world = p.m_9236_();
        BlockPos blockpos = BlockPos.m_274561_((double)p.m_20185_(), (double)(p.m_20191_().f_82289_ - 1.0), (double)p.m_20189_());
        BlockState bs = world.m_8055_(blockpos);
        float f5 = bs.getFriction((LevelReader)world, blockpos, (Entity)p);
        p.m_19920_(AutoSprintUtil.getRelevantMoveFactor(p, f5), vec);
    }

    public static float getRelevantMoveFactor(LivingEntity p, float flt) {
        Player pl;
        if (p instanceof Player && (pl = (Player)p).m_7500_()) {
            return p.m_6113_() * (0.21600002f / (flt * flt * flt));
        }
        return p.m_20096_() ? p.m_6113_() * (0.21600002f / (flt * flt * flt)) : p.m_6113_() * 0.1f;
    }

    public static float getRelevantMoveFactorBoat(Boat p, float flt) {
        float aiMoveSpeedMock = 0.0383f;
        return 0.0383f * (0.21600002f / (flt * flt * flt));
    }

    public static void setAutorunState(Player player, boolean value) {
        player.getPersistentData().m_128379_(NBT, value);
        player.m_5661_((Component)Component.m_237115_((String)("autorun." + value)), true);
        player.m_6858_(value);
    }

    public static boolean getAutorunState(Player player) {
        if (player == null || player.getPersistentData() == null) {
            return false;
        }
        return player.getPersistentData().m_128471_(NBT);
    }

    public static boolean doesKeypressHaltSprint(Player p) {
        if (p.m_20202_() instanceof Boat) {
            return Minecraft.m_91087_().f_91066_.f_92085_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92087_.m_90857_();
        }
        return Minecraft.m_91087_().f_91066_.f_92085_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92087_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92086_.m_90857_() || Minecraft.m_91087_().f_91066_.f_92088_.m_90857_();
    }
}

