/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.text.v1;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.web.WebUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class TextElement
extends AbstractElement {
    public SourceMode sourceMode = SourceMode.DIRECT;
    public String source;
    public boolean shadow = true;
    public CaseMode caseMode = CaseMode.NORMAL;
    public float scale = 1.0f;
    public AbstractElement.Alignment alignment = AbstractElement.Alignment.LEFT;
    public String baseColorHex = null;
    public int textBorder = 0;
    public int lineSpacing = 1;
    public String scrollGrabberTextureNormal = null;
    public String scrollGrabberTextureHover = null;
    public String scrollGrabberColorHexNormal = null;
    public String scrollGrabberColorHexHover = null;
    public boolean enableScrolling = true;
    protected Font font;
    public volatile ScrollArea scrollArea;
    public volatile LinkedListMultimap<String, Float> lines;
    public volatile boolean updating;

    public TextElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = Minecraft.m_91087_().f_91062_;
        this.lines = LinkedListMultimap.create();
        this.updating = false;
    }

    public void updateScrollArea() {
        ITexture r;
        Color c;
        this.scrollArea = new ScrollArea(0, 0, this.getAbsoluteWidth(), this.getAbsoluteHeight()){

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
                super.render(graphics, mouseX, mouseY, partial);
                this.verticalScrollBar.active = this.getTotalEntryHeight() > this.getInnerHeight() && TextElement.this.enableScrolling;
            }

            @Override
            public void updateScrollArea() {
                super.updateScrollArea();
                if (Minecraft.m_91087_().f_91080_ != null) {
                    this.verticalScrollBar.scrollAreaEndX = TextElement.this.getAbsoluteX() + TextElement.this.getAbsoluteWidth() + 12;
                    this.horizontalScrollBar.scrollAreaEndY = TextElement.this.getAbsoluteY() + TextElement.this.getAbsoluteHeight() + 12;
                }
            }
        };
        this.scrollArea.verticalScrollBar.grabberWidth = 10;
        this.scrollArea.verticalScrollBar.grabberHeight = 20;
        this.scrollArea.horizontalScrollBar.grabberWidth = 20;
        this.scrollArea.horizontalScrollBar.grabberHeight = 10;
        this.scrollArea.backgroundColor = new Color(0, 0, 0, 0);
        this.scrollArea.borderColor = new Color(0, 0, 0, 0);
        this.scrollArea.verticalScrollBar.setScrollWheelAllowed(this.enableScrolling);
        this.scrollArea.verticalScrollBar.active = false;
        this.scrollArea.horizontalScrollBar.active = false;
        if (this.scrollGrabberColorHexNormal != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexNormal)) != null) {
            this.scrollArea.verticalScrollBar.idleBarColor = c;
            this.scrollArea.horizontalScrollBar.idleBarColor = c;
        }
        if (this.scrollGrabberColorHexHover != null && (c = RenderUtils.getColorFromHexString((String)this.scrollGrabberColorHexHover)) != null) {
            this.scrollArea.verticalScrollBar.hoverBarColor = c;
            this.scrollArea.horizontalScrollBar.hoverBarColor = c;
        }
        if (this.scrollGrabberTextureNormal != null && (r = ResourceHandlers.getImageHandler().get(this.scrollGrabberTextureNormal)) != null) {
            this.scrollArea.verticalScrollBar.idleBarTexture = r.getResourceLocation();
            this.scrollArea.horizontalScrollBar.idleBarTexture = r.getResourceLocation();
        }
        if (this.scrollGrabberTextureHover != null && (r = ResourceHandlers.getImageHandler().get(this.scrollGrabberTextureHover)) != null) {
            this.scrollArea.verticalScrollBar.hoverBarTexture = r.getResourceLocation();
            this.scrollArea.horizontalScrollBar.hoverBarTexture = r.getResourceLocation();
        }
        LineScrollEntry borderTop = new LineScrollEntry(this.scrollArea, " ", false, 1.0f, this);
        borderTop.setHeight(this.textBorder);
        this.scrollArea.addEntry(borderTop);
        for (Map.Entry m : this.lines.entries()) {
            this.scrollArea.addEntry(new LineScrollEntry(this.scrollArea, (String)m.getKey(), false, this.scale, this));
        }
        LineScrollEntry borderBottom = new LineScrollEntry(this.scrollArea, " ", false, 1.0f, this);
        borderBottom.setHeight(this.textBorder);
        this.scrollArea.addEntry(borderBottom);
    }

    public Color getBaseColor() {
        if (this.baseColorHex != null) {
            return RenderUtils.getColorFromHexString((String)this.baseColorHex);
        }
        return null;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        try {
            if (this.shouldRender()) {
                if (!this.updating) {
                    RenderSystem.enableBlend();
                    if (this.scrollArea != null) {
                        this.scrollArea.customGuiScale = this.customGuiScale;
                        this.scrollArea.setX(this.getAbsoluteX(), true);
                        this.scrollArea.setY(this.getAbsoluteY(), true);
                        this.scrollArea.setWidth(this.getAbsoluteWidth(), true);
                        this.scrollArea.setHeight(this.getAbsoluteHeight(), true);
                        this.scrollArea.render(graphics, MouseInput.getMouseX(), MouseInput.getMouseY(), RenderingUtils.getPartialTick());
                    }
                } else if (TextElement.isEditor()) {
                    graphics.m_280509_(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), Color.MAGENTA.getRGB());
                    MutableComponent mutableComponent = Component.m_237115_((String)"fancymenu.customization.items.text.status.loading");
                    int n = this.getAbsoluteX() + this.getAbsoluteWidth() / 2;
                    int n2 = this.getAbsoluteY() + this.getAbsoluteHeight() / 2;
                    Objects.requireNonNull(this.font);
                    graphics.m_280653_(this.font, (Component)mutableComponent, n, n2 - 9 / 2, -1);
                }
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateContent() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        new Thread(() -> {
            ArrayList<String> linesRaw;
            block23: {
                linesRaw = new ArrayList<String>();
                try {
                    if (this.source != null && !this.source.equals("")) {
                        String path;
                        if (this.sourceMode == SourceMode.DIRECT) {
                            if (this.source.replace("\\n", "%n%").replace("\\r", "%n%").contains("%n%")) {
                                linesRaw.addAll(Arrays.asList(StringUtils.splitLines((String)this.source.replace("\\n", "%n%").replace("\\r", "%n%"), (String)"%n%")));
                            } else {
                                linesRaw.add(this.source);
                            }
                            break block23;
                        }
                        if (this.sourceMode == SourceMode.LOCAL_SOURCE) {
                            File f = new File(PlaceholderParser.replacePlaceholders(this.source));
                            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.m_91087_().f_91069_.getAbsolutePath().replace("\\", "/"))) {
                                f = new File(Minecraft.m_91087_().f_91069_.getAbsolutePath().replace("\\", "/") + "/" + PlaceholderParser.replacePlaceholders(this.source));
                            }
                            if (f.isFile()) {
                                linesRaw.addAll(FileUtils.getFileLines((File)f));
                            }
                            break block23;
                        }
                        if (this.sourceMode != SourceMode.WEB_SOURCE || !WebUtils.isValidUrl((String)StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.source), (String)"\u00a7", (String)"&"))) break block23;
                        Object fixedSource = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(this.source), (String)"\u00a7", (String)"&");
                        if (((String)fixedSource).toLowerCase().contains("/blob/") && (((String)fixedSource).toLowerCase().startsWith("http://github.com/") || ((String)fixedSource).toLowerCase().startsWith("https://github.com/") || ((String)fixedSource).toLowerCase().startsWith("http://www.github.com/") || ((String)fixedSource).toLowerCase().startsWith("https://www.github.com/"))) {
                            path = ((String)fixedSource).replace("//", "").split("/", 2)[1].replace("/blob/", "/");
                            fixedSource = "https://raw.githubusercontent.com/" + path;
                        }
                        if (!((String)fixedSource).toLowerCase().contains("/raw/") && (((String)fixedSource).toLowerCase().startsWith("http://pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("https://pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("http://www.pastebin.com/") || ((String)fixedSource).toLowerCase().startsWith("https://www.pastebin.com/"))) {
                            path = ((String)fixedSource).replace("//", "").split("/", 2)[1];
                            fixedSource = "https://pastebin.com/raw/" + path;
                        }
                        BufferedReader r = null;
                        try {
                            URL url = new URL((String)fixedSource);
                            r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                            String s = r.readLine();
                            while (s != null) {
                                linesRaw.add(s);
                                s = r.readLine();
                            }
                            r.close();
                        }
                        catch (Exception e) {
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                            }
                            linesRaw.clear();
                        }
                        break block23;
                    }
                    linesRaw.add(I18n.m_118938_((String)"fancymenu.customization.items.text.placeholder", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    linesRaw.clear();
                }
            }
            this.lines.clear();
            if (linesRaw.isEmpty()) {
                if (TextElement.isEditor()) {
                    linesRaw.add(I18n.m_118938_((String)"fancymenu.customization.items.text.status.unable_to_load", (Object[])new Object[0]));
                } else {
                    linesRaw.add("");
                }
            }
            for (String s : linesRaw) {
                float sc = TextElement.getScaleMultiplicator(s);
                s = TextElement.getWithoutHeadlineCodes(s);
                if (this.caseMode == CaseMode.ALL_LOWER) {
                    s = s.toLowerCase();
                }
                if (this.caseMode == CaseMode.ALL_UPPER) {
                    s = s.toUpperCase();
                }
                this.lines.put((Object)s, (Object)Float.valueOf(sc));
            }
            MainThreadTaskExecutor.executeInMainThread(this::updateScrollArea, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            this.updating = false;
        }).start();
    }

    protected static float getScaleMultiplicator(String s) {
        if (s.startsWith("### ")) {
            return 1.1f;
        }
        if (s.startsWith("## ")) {
            return 1.3f;
        }
        if (s.startsWith("# ")) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected static String getWithoutHeadlineCodes(String s) {
        if (s.startsWith("### ")) {
            return s.substring(4);
        }
        if (s.startsWith("## ")) {
            return s.substring(3);
        }
        if (s.startsWith("# ")) {
            return s.substring(2);
        }
        return s;
    }

    public static enum SourceMode {
        DIRECT("direct"),
        LOCAL_SOURCE("local"),
        WEB_SOURCE("web");

        final String name;

        private SourceMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SourceMode getByName(String name) {
            for (SourceMode i : SourceMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }

    public static enum CaseMode {
        NORMAL("normal"),
        ALL_LOWER("lower"),
        ALL_UPPER("upper");

        final String name;

        private CaseMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static CaseMode getByName(String name) {
            for (CaseMode i : CaseMode.values()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }
    }

    public static class LineScrollEntry
    extends TextScrollAreaEntry {
        public final String textRaw;
        public final boolean bold;
        public final float scale;
        public final TextElement parentItem;
        protected String lastTextToRender;

        public LineScrollEntry(ScrollArea parent, String textRaw, boolean bold, float scale, TextElement parentItem) {
            super(parent, (Component)Component.m_237113_((String)""), entry -> {});
            this.textRaw = textRaw;
            this.bold = bold;
            this.scale = scale;
            this.parentItem = parentItem;
            this.selectable = false;
            this.playClickSound = false;
            this.backgroundColorIdle = new Color(0, 0, 0, 0);
            this.backgroundColorHover = new Color(0, 0, 0, 0);
            this.buttonBase.m_93650_(0.0f);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.setHeight((int)(9.0f * scale) + parentItem.lineSpacing);
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.enableBlend();
            String textToRender = PlaceholderParser.replacePlaceholders(this.textRaw, true);
            if (this.parentItem.caseMode == CaseMode.ALL_LOWER) {
                textToRender = textToRender.toLowerCase();
            } else if (this.parentItem.caseMode == CaseMode.ALL_UPPER) {
                textToRender = textToRender.toUpperCase();
            }
            if (this.lastTextToRender == null || !this.lastTextToRender.equals(textToRender)) {
                this.setTextOfLine(Component.m_237113_((String)textToRender));
                ((MutableComponent)this.getText()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(this.bold)));
            }
            this.lastTextToRender = textToRender;
            this.updateEntry();
            this.buttonBase.m_88315_(graphics, mouseX, mouseY, partial);
            int textX = (int)((float)this.getX() / this.scale);
            if (this.parentItem.alignment == AbstractElement.Alignment.LEFT) {
                textX += this.parentItem.textBorder;
            } else if (this.parentItem.alignment == AbstractElement.Alignment.RIGHT) {
                textX = (int)((float)textX + (float)(this.getWidth() - this.textWidth) / this.scale);
                textX -= this.parentItem.textBorder;
            } else if (this.parentItem.alignment == AbstractElement.Alignment.CENTERED) {
                textX = (int)((float)textX + (float)(this.getWidth() - this.textWidth) / this.scale / 2.0f);
            }
            int centerY = (int)((float)this.getY() / this.scale) + this.getHeight() / 2;
            Objects.requireNonNull(this.font);
            int textY = centerY - (int)((float)(9 / 2) * this.scale);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
            Color c = this.parentItem.getBaseColor();
            int textColor = c != null ? FastColor.ARGB32.m_13660_((int)Math.max(0, Math.min(255, (int)(this.parentItem.opacity * 255.0f))), (int)c.getRed(), (int)c.getGreen(), (int)c.getBlue()) : FastColor.ARGB32.m_13660_((int)Math.max(0, Math.min(255, (int)(this.parentItem.opacity * 255.0f))), (int)255, (int)255, (int)255);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280614_(this.font, this.text, textX, textY, textColor, this.parentItem.shadow);
            graphics.m_280168_().m_85849_();
        }

        public void setTextOfLine(MutableComponent text) {
            this.text = text;
            this.textWidth = (int)((float)this.font.m_92852_((FormattedText)this.text) * this.scale);
            this.setWidth(this.parentItem.textBorder + this.textWidth + this.parentItem.textBorder);
        }
    }
}

