/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.image;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.image.ImageElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ImageEditorElement
extends AbstractEditorElement {
    public ImageEditorElement(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor);
    }

    @Override
    public void init() {
        super.init();
        this.rightClickMenu.addClickableEntry("set_source", (Component)Component.m_237115_((String)"fancymenu.elements.image.set_source"), (menu, entry) -> Minecraft.m_91087_().m_91152_(ResourceChooserScreen.image(null, source -> {
            if (source != null) {
                this.editor.history.saveSnapshot();
                this.getElement().textureSupplier = ResourceSupplier.image(source);
            }
            Minecraft.m_91087_().m_91152_((Screen)this.editor);
        }).setSource(this.getElement().textureSupplier != null ? this.getElement().textureSupplier.getSourceWithPrefix() : null, false))).setIcon(ContextMenu.IconFactory.getIcon("image"));
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "image_tint", ImageEditorElement.class, consumes -> consumes.getElement().imageTint.getHex(), (imageEditorElement, s) -> {
            imageEditorElement.getElement().imageTint = DrawableColor.of(s != null ? s : "#FFFFFF");
        }, null, false, false, (Component)Component.m_237115_((String)"fancymenu.elements.image.tint"), true, "#FFFFFF", TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setStackable(true);
        this.rightClickMenu.addSeparatorEntry("separator_before_repeat_texture");
        ((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "repeat_texture", ImageEditorElement.class, consumes -> consumes.getElement().repeat, (imageEditorElement, aBoolean) -> {
            imageEditorElement.getElement().repeat = aBoolean;
        }, "fancymenu.elements.image.repeat").setIsActiveSupplier((menu, entry) -> !this.getElement().nineSlice)).setStackable(false);
        this.rightClickMenu.addSeparatorEntry("separator_before_nine_slice_settings");
        ((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "nine_slice_texture", ImageEditorElement.class, consumes -> consumes.getElement().nineSlice, (imageEditorElement, aBoolean) -> {
            imageEditorElement.getElement().nineSlice = aBoolean;
        }, "fancymenu.elements.image.nine_slice").setIsActiveSupplier((menu, entry) -> !this.getElement().repeat)).setStackable(false);
        ((ContextMenu.ClickableContextMenuEntry)this.addIntegerInputContextMenuEntryTo(this.rightClickMenu, "nine_slice_border_x", ImageEditorElement.class, consumes -> consumes.getElement().nineSliceBorderX, (imageEditorElement, integer) -> {
            imageEditorElement.getElement().nineSliceBorderX = integer;
        }, (Component)Component.m_237115_((String)"fancymenu.elements.image.nine_slice.border_x"), true, 5, null, null).setStackable(false)).setIsActiveSupplier((menu, entry) -> !this.getElement().repeat);
        ((ContextMenu.ClickableContextMenuEntry)this.addIntegerInputContextMenuEntryTo(this.rightClickMenu, "nine_slice_border_y", ImageEditorElement.class, consumes -> consumes.getElement().nineSliceBorderY, (imageEditorElement, integer) -> {
            imageEditorElement.getElement().nineSliceBorderY = integer;
        }, (Component)Component.m_237115_((String)"fancymenu.elements.image.nine_slice.border_y"), true, 5, null, null).setStackable(false)).setIsActiveSupplier((menu, entry) -> !this.getElement().repeat);
        this.rightClickMenu.addSeparatorEntry("image_separator_1");
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("restore_aspect_ratio", (Component)Component.m_237115_((String)"fancymenu.elements.image.restore_aspect_ratio"), (menu, entry) -> {
            List<AbstractEditorElement> selectedElements = ListUtils.filterList(this.editor.getSelectedElements(), consumes -> consumes instanceof ImageEditorElement);
            this.editor.history.saveSnapshot();
            for (AbstractEditorElement e : selectedElements) {
                ((ImageElement)e.element).restoreAspectRatio();
            }
        }).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("aspect_ratio"));
    }

    public ImageElement getElement() {
        return (ImageElement)this.element;
    }
}

