/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SkinGrabber {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String URL = "https://mineskin.eu/skin/";
    public static final String DEFAULT_DIR = "./fakeplayers/skins/";
    public static final String ERROR_SKIN = "textures/entities/humanoid/error.png";
    public static final HashMap<String, ResourceLocation> SKIN_LIST = new HashMap();

    public static ResourceLocation getEntitySkinFromList(Entity entity) {
        ResourceLocation location = SkinGrabber.getSkinFromListKey(entity.m_20149_());
        return location;
    }

    public static String formatEntityCustomName(Entity entity) {
        return entity.m_7755_().getString().toLowerCase().replace(" ", "");
    }

    public static ResourceLocation getEntitySkinFromFile(Entity entity) {
        File file = new File(DEFAULT_DIR + SkinGrabber.formatEntityCustomName(entity) + ".png");
        ResourceLocation location = SkinGrabber.fileToLocation(file);
        return location;
    }

    public static ResourceLocation getCustomNameSkinFromFile(String name) {
        File file = new File(DEFAULT_DIR + name.toLowerCase().replace(" ", "") + ".png");
        ResourceLocation location = SkinGrabber.fileToLocation(file);
        return location;
    }

    public static void addEntityToList(Entity entity) {
        ResourceLocation location = SkinGrabber.getEntitySkinFromFile(entity);
        SKIN_LIST.put(SkinGrabber.formatEntityCustomName(entity), location);
    }

    public static void addCustomNameToList(String name) {
        ResourceLocation location = SkinGrabber.getCustomNameSkinFromFile(name);
        SKIN_LIST.put(name.toLowerCase().replace(" ", ""), location);
    }

    public static void clearTextures() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null) {
            TextureManager manager = minecraft.m_91097_();
            if (!SKIN_LIST.isEmpty()) {
                SKIN_LIST.forEach((uuid, resourceLocation) -> manager.m_118513_(resourceLocation));
                SKIN_LIST.clear();
            }
        }
    }

    public static ResourceLocation getSkinFromListKey(String key) {
        if (SKIN_LIST.containsKey(key)) {
            return SKIN_LIST.get(key);
        }
        return null;
    }

    public static ResourceLocation fileToLocation(File file) {
        NativeImage image = null;
        try {
            image = SkinGrabber.processLegacySkin(NativeImage.m_85058_((InputStream)new FileInputStream(file)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image == null) {
            return new ResourceLocation("fakeplayers", ERROR_SKIN);
        }
        return SkinGrabber.registerImage(image);
    }

    public static ResourceLocation registerImage(NativeImage image) {
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        return manager.m_118490_("humanoid", new DynamicTexture(image));
    }

    public static boolean isValidURL(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    public static void downloadImageFromURL(String filename, File filepath, String URL2) {
        try {
            URL url = new URL(URL2);
            URLConnection connection = url.openConnection();
            connection.connect();
            connection.setConnectTimeout(0);
            BufferedImage image = ImageIO.read(connection.getInputStream());
            if (!filepath.exists()) {
                filepath.mkdirs();
            }
            ImageIO.write((RenderedImage)image, "png", new File(filepath, filename + ".png"));
            System.out.println(image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void downloadSkinFromUsername(String username, File filepath) {
        SkinGrabber.downloadImageFromURL(username, filepath, URL + username);
    }

    @Nullable
    private static NativeImage processLegacySkin(NativeImage image) {
        int i = image.m_85084_();
        int j = image.m_84982_();
        if (j == 64 && (i == 32 || i == 64)) {
            boolean flag;
            boolean bl = flag = i == 32;
            if (flag) {
                NativeImage nativeimage = new NativeImage(64, 64, true);
                nativeimage.m_85054_(image);
                image.close();
                image = nativeimage;
                nativeimage.m_84997_(0, 32, 64, 32, 0);
                nativeimage.m_85025_(4, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(8, 16, 16, 32, 4, 4, true, false);
                nativeimage.m_85025_(0, 20, 24, 32, 4, 12, true, false);
                nativeimage.m_85025_(4, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(8, 20, 8, 32, 4, 12, true, false);
                nativeimage.m_85025_(12, 20, 16, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(48, 16, -8, 32, 4, 4, true, false);
                nativeimage.m_85025_(40, 20, 0, 32, 4, 12, true, false);
                nativeimage.m_85025_(44, 20, -8, 32, 4, 12, true, false);
                nativeimage.m_85025_(48, 20, -16, 32, 4, 12, true, false);
                nativeimage.m_85025_(52, 20, -8, 32, 4, 12, true, false);
            }
            SkinGrabber.setNoAlpha(image, 0, 0, 32, 16);
            if (flag) {
                SkinGrabber.doNotchTransparencyHack(image, 32, 0, 64, 32);
            }
            SkinGrabber.setNoAlpha(image, 0, 16, 64, 32);
            SkinGrabber.setNoAlpha(image, 16, 48, 48, 64);
            return image;
        }
        image.close();
        LOGGER.warn("Discarding incorrectly sized ({}x{}) skin texture", (Object)j, (Object)i);
        return null;
    }

    private static void doNotchTransparencyHack(NativeImage p_118013_, int p_118014_, int p_118015_, int p_118016_, int p_118017_) {
        for (int i = p_118014_; i < p_118016_; ++i) {
            for (int j = p_118015_; j < p_118017_; ++j) {
                int k = p_118013_.m_84985_(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = p_118014_; l < p_118016_; ++l) {
            for (int i1 = p_118015_; i1 < p_118017_; ++i1) {
                p_118013_.m_84988_(l, i1, p_118013_.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }

    private static void setNoAlpha(NativeImage p_118023_, int p_118024_, int p_118025_, int p_118026_, int p_118027_) {
        for (int i = p_118024_; i < p_118026_; ++i) {
            for (int j = p_118025_; j < p_118027_; ++j) {
                p_118023_.m_84988_(i, j, p_118023_.m_84985_(i, j) | 0xFF000000);
            }
        }
    }
}

