/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking.packets;

import com.duzo.fakeplayers.common.entities.HumanoidEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateHumanoidSittingC2SPacket {
    public boolean messageIsValid;
    private UUID uuid;
    private boolean sat;

    public UpdateHumanoidSittingC2SPacket(UUID humanoidUUID, boolean sat) {
        this.uuid = humanoidUUID;
        this.sat = sat;
        this.messageIsValid = true;
    }

    public UpdateHumanoidSittingC2SPacket() {
        this.messageIsValid = false;
    }

    public static UpdateHumanoidSittingC2SPacket decode(FriendlyByteBuf buf) {
        UpdateHumanoidSittingC2SPacket packet = new UpdateHumanoidSittingC2SPacket();
        try {
            packet.sat = buf.readBoolean();
            packet.uuid = buf.m_130259_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.out.println("Exception while reading Packet: " + e);
            return packet;
        }
        packet.messageIsValid = true;
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeBoolean(this.sat);
        buf.m_130077_(this.uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            Entity patt1860$temp = level.m_8791_(this.uuid);
            if (patt1860$temp instanceof HumanoidEntity) {
                HumanoidEntity humanoid = (HumanoidEntity)patt1860$temp;
                humanoid.setSitting(this.sat);
            }
        });
        return true;
    }
}

