/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking.packets;

import com.duzo.fakeplayers.common.entities.humanoids.FakePlayerEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateHumanoidAIC2SPacket {
    public boolean messageIsValid;
    private UUID uuid;
    private boolean noAI;
    private boolean setTarget;
    private boolean forceTargeting;

    public UpdateHumanoidAIC2SPacket(UUID humanoidUUID, boolean noAI, boolean setTarget, boolean forceTarget) {
        this.uuid = humanoidUUID;
        this.noAI = noAI;
        this.setTarget = setTarget;
        this.forceTargeting = forceTarget;
        this.messageIsValid = true;
    }

    public UpdateHumanoidAIC2SPacket() {
        this.messageIsValid = false;
    }

    public static UpdateHumanoidAIC2SPacket decode(FriendlyByteBuf buf) {
        UpdateHumanoidAIC2SPacket packet = new UpdateHumanoidAIC2SPacket();
        try {
            packet.noAI = buf.readBoolean();
            packet.uuid = buf.m_130259_();
            packet.setTarget = buf.readBoolean();
            packet.forceTargeting = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.out.println("Exception while reading Packet: " + e);
            return packet;
        }
        packet.messageIsValid = true;
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.writeBoolean(this.noAI);
        buf.m_130077_(this.uuid);
        buf.writeBoolean(this.setTarget);
        buf.writeBoolean(this.forceTargeting);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            Entity patt2236$temp = level.m_8791_(this.uuid);
            if (patt2236$temp instanceof FakePlayerEntity) {
                FakePlayerEntity humanoid = (FakePlayerEntity)patt2236$temp;
                humanoid.m_21557_(this.noAI);
                if (this.forceTargeting) {
                    humanoid.setForceTargeting((LivingEntity)player);
                } else {
                    humanoid.setForceTargeting(false);
                }
            }
        });
        return true;
    }
}

