/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking.packets;

import com.duzo.fakeplayers.client.threads.SkinDownloaderThread;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendSkinMessageS2CPacket {
    private String name;
    public boolean messageIsValid;

    public SendSkinMessageS2CPacket(String name) {
        this.name = name;
        this.messageIsValid = true;
        System.out.println("Skin packet initialised with string : " + this.name);
    }

    public SendSkinMessageS2CPacket() {
        this.messageIsValid = false;
    }

    public static SendSkinMessageS2CPacket decode(FriendlyByteBuf buf) {
        SendSkinMessageS2CPacket skinPacket = new SendSkinMessageS2CPacket();
        try {
            String name;
            skinPacket.name = name = buf.m_130277_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.out.println("Exception while reading Packet: " + e);
            return skinPacket;
        }
        skinPacket.messageIsValid = true;
        return skinPacket;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.m_130070_(this.name);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        System.out.println("Skin Packet Received");
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            SkinDownloaderThread skinThread = new SkinDownloaderThread(this.name);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> skinThread);
        });
        return true;
    }
}

