/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking.packets;

import com.duzo.fakeplayers.client.threads.ImageDownloaderThread;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendImageDownloadMessageS2CPacket {
    private String filename;
    private File filepath;
    private String URL;
    private String uuid;
    public boolean messageIsValid;

    public SendImageDownloadMessageS2CPacket(String uuid, String filename, File filepath, String URL2) {
        this.uuid = uuid;
        this.filename = filename;
        this.filepath = filepath;
        this.URL = URL2;
        this.messageIsValid = true;
    }

    public SendImageDownloadMessageS2CPacket() {
        this.messageIsValid = false;
    }

    public static SendImageDownloadMessageS2CPacket decode(FriendlyByteBuf buf) {
        SendImageDownloadMessageS2CPacket packet = new SendImageDownloadMessageS2CPacket();
        try {
            String uuid = buf.m_130277_();
            String filename = buf.m_130277_();
            String filepathString = buf.m_130277_();
            String URL2 = buf.m_130277_();
            File filepath = new File(filepathString);
            packet.uuid = uuid;
            packet.filename = filename;
            packet.filepath = filepath;
            packet.URL = URL2;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.out.println("Exception while reading Packet: " + e);
            return packet;
        }
        packet.messageIsValid = true;
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.m_130070_(this.uuid);
        buf.m_130070_(this.filename);
        buf.m_130070_(this.filepath.getAbsolutePath());
        buf.m_130070_(this.URL);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ImageDownloaderThread thread = new ImageDownloaderThread(this.uuid, this.filename, this.filepath, this.URL);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> thread);
        });
        return true;
    }
}

