/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking.packets;

import com.duzo.fakeplayers.common.entities.humanoids.FakePlayerEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SendHumanoidChatC2SPacket {
    public boolean messageIsValid;
    private UUID uuid;
    private String message;

    public SendHumanoidChatC2SPacket(UUID humanoidUUID, String message) {
        this.uuid = humanoidUUID;
        this.message = message;
        this.messageIsValid = true;
    }

    public SendHumanoidChatC2SPacket() {
        this.messageIsValid = false;
    }

    public static SendHumanoidChatC2SPacket decode(FriendlyByteBuf buf) {
        SendHumanoidChatC2SPacket packet = new SendHumanoidChatC2SPacket();
        try {
            packet.uuid = buf.m_130259_();
            packet.message = buf.m_130277_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.out.println("Exception while reading Packet: " + e);
            return packet;
        }
        packet.messageIsValid = true;
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        buf.m_130077_(this.uuid);
        buf.m_130070_(this.message);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = (ServerLevel)player.m_9236_();
            Entity patt1856$temp = level.m_8791_(this.uuid);
            if (patt1856$temp instanceof FakePlayerEntity) {
                FakePlayerEntity humanoid = (FakePlayerEntity)patt1856$temp;
                humanoid.sendChat(this.message);
            }
        });
        return true;
    }
}

